<?php
/**
 * @package    Joomla.Plugin
 * @subpackage Content.sismosprivacynoteswitch
 *
 * @author     Martina Scholz <martina@simplysmart-it.de>
 * @copyright  Martina Scholz - SimplySmart-IT
 * @license    GNU General Public License version 3 or later; see LICENSE.txt
 * @link       https://simplysmart-it.de
 */
 
 namespace Sismos\Plugin\Content\Sismosprivacynoteswitch\Extension;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Factory;

/**
 * SimplySmart-OS PrivacyNoteSwitch plugin.
 *
 * @since     1.0.0
 */
class Sismosprivacynoteswitch extends CMSPlugin  implements SubscriberInterface
{
	/**
	 * Application object
	 *
	 * @var    \Joomla\CMS\Application\SiteApplication
	 * @since  3.9.0
	 */
	protected $app;
	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 * @since  3.9.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * The supported form contexts
	 *
	 * @var    array
	 * @since  3.9.0
	 */
	protected $supportedContext = [
		'com_contact.contact'
	];
	
	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   4.0.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepareForm' => ['switchToNoteField', \Joomla\Event\Priority::MIN]
		];
	}

	/**
	 * Add additional fields to the supported forms
	 *
	 * @param   \Joomla\Event\Event $event
	 * @param   Form   $form  The form to be altered.
	 * @param   mixed  $data  The associated data for the form.
	 *
	 * @return  void
	 *
	 * @since   3.9.0
	 */
	public function switchToNoteField(\Joomla\Event\Event $event)
	{
		if (!Factory::getApplication()->isClient('site'))
		{
			return;
		}

		$document = Factory::getApplication()->getDocument();

        if (!($document instanceof \Joomla\CMS\Document\HtmlDocument))
        {
            return;
        }
		
		/** @var Form $form  - The form to be altered*/

		[$form, $data] = $event->getArguments();

		if (!in_array($form->getName(), $this->supportedContext))
		{
			return;
		}

		if (!\Joomla\CMS\Plugin\PluginHelper::isEnabled('content', 'confirmconsent')) {
			return;
		}

		$form->setFieldAttribute('consentbox','type','SismosConsentNote');
		$form->setFieldAttribute('consentbox','addfieldprefix', "Sismos\\Plugin\\Content\\Sismosprivacynoteswitch\\Field");
		$form->setFieldAttribute('consentbox','required', 'false');

		$event->setArgument(0, $form);

		return;
	}
}
