<?php

/**
 * @package    Sismos.Plugin
 * @subpackage Content.sismosautotoc
 *
 * @copyright  (C) 2023 - 2024, SimplySmart-IT - Martina Scholz <https://simplysmart-it.de>
 * @license    GNU General Public License version 3 or later; see LICENSE
 * @link       https://simplysmart-it.de
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

?>

<div class="autotoc autotoc__container<?php echo(($this->params->get('boxshadow', 0) ? ' shadow' : '')); ?><?php echo(($this->params->get('floatend', 1) && !$this->params->get('collapsable', 0)) ? ' float-end' : ''); ?>">
    <div class="autotoc__body">
        <?php if ($headline) : ?>
            <p class="autotoc__headline"><?php echo Text::_($headline); ?></p>
        <?php endif; ?>
        <ul class="autotoc__list">
        <?php foreach ($this->tableToc as $tocItem) : ?>
            <?php $class = ' toclink__level' . $tocItem->get('level'); ?>
            <li class="toclink<?php echo $class;?>">
                <a href="<?php echo Route::_($tocItem->get('link', '#')); ?>">
                    <?php echo $tocItem->get('title', ''); ?>
                </a>
            </li>
        <?php endforeach; ?>
        </ul>
    </div>
</div>