<?php

/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Version;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern (Reg Ex) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellcheck      Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   string   $dataAttribute   Miscellaneous data attributes preprocessed for HTML output
 * @var   array    $dataAttributes  Miscellaneous data attribute for eg, data-*
 * @var   string   $valueTitle
 * @var   array    $canDo
 * @var   string   $url
 * @var   string   $checkin
 * @var   string   $modalTitle
 * @var   string   $buttonIcon
 * @var   string   $buttonText
 */

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->useScript('joomla.dialog-autocreate');

if ($modalTitle) {
    $titleLayout = new FileLayout('joomla.toolbar.title');
    $modalTitle  = $titleLayout->render(['title' => Text::_($modalTitle), 'icon' => $buttonIcon ?? 'plug plugin']);
}

$modal = [
    'popupType'  => 'iframe',
    'src'        => empty($url) ? '' : Route::_($url, false),
    'textHeader' => ($modalTitle) ? Text::_($modalTitle) : '',
];

?>

<div class="js-modal-edit-field <?php echo $class; ?>" <?php echo $dataAttribute; ?>>
    <?php if ($modal['src']) : ?>
    <button type="button" class="btn btn-primary"
            data-joomla-dialog="<?php echo $this->escape(json_encode($modal, JSON_UNESCAPED_SLASHES)); ?>"
            <?php echo isset($checkin) ? 'data-checkin-url="' . Route::_($checkin) . '"' : ''; ?>
            data-close-on-message>
        <span class="<?php echo !empty($buttonIcon) ? $buttonIcon : 'icon-pen-square'; ?>" aria-hidden="true"></span> <?php echo !empty($buttonText) ? Text::_($buttonText) : Text::_('JACTION_EDIT'); ?>
    </button>
    <?php endif; ?>
</div>