<?php

/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Version;

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern (Reg Ex) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellcheck      Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   string   $dataAttribute   Miscellaneous data attributes preprocessed for HTML output
 * @var   array    $dataAttributes  Miscellaneous data attribute for eg, data-*
 * @var   string   $valueTitle
 * @var   array    $canDo
 * @var   string   $url
 * @var   string   $checkin
 * @var   string   $modalTitle
 * @var   string   $buttonIcon
 * @var   string   $buttonText
 */

// if($modalTitle) {
// $titleLayout = new FileLayout('joomla.toolbar.title');
// $modalTitle  = $titleLayout->render(['title' => Text::_($modalTitle), 'icon' => $buttonIcon ?? 'plug plugin']);
// }

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

// Add the modal field script to the document head.
$wa->useScript('field.modal-fields');

// $modalParams['title']      = Text::_($modalTitle);
// $modalParams['url']        = empty($url) ? '' : Route::_($url, false);
// $modalParams['height']     = '100%';
// $modalParams['width']      = '100%';
// $modalParams['bodyHeight'] = 70;
// $modalParams['modalWidth'] = 80;
// $modalParams['closeButton'] = false;
// $modalParams['footer']    = '<button type="button" data-bs-dismiss="modal" class="btn btn-light btn-sm me-auto">' . Text::_('JCANCEL') . '</button><button type="button" class="btn btn-success btn-sm save-item">' . Text::_('JSUBMIT') . '</button>';
$modalParams = [
    'title'       => Text::_($modalTitle),
    'backdrop'    => 'static',
    'keyboard'    => false,
    'closeButton' => true,
    'url'         => empty($url) ? '' : Route::_($url, false),
    'height'      => '100%',
    'width'       => '100%',
    'bodyHeight'  => 70,
    'modalWidth'  => 80,
    'footer'      => '<button type="button" class="btn btn-secondary"'
            . ' onclick="window.processModalEdit(this, \'' . $id
            . '\', \'edit\', \'plugin\', \'cancel\', \'style-form\', \'jform_id\', \'jform_name\'); return false;">'
            . Text::_('JCANCEL') . '</button>'
            . '<button type="button" class="btn btn-success"'
            . ' onclick="window.processModalEdit(this, \''
            . $id . '\', \'edit\', \'plugin\', \'save\', \'style-form\', \'jform_id\', \'jform_name\'); return false;">'
            . Text::_('JAPPLY') . '</button>',
];
$modalHtml = HTMLHelper::_('bootstrap.renderModal', 'modal-' . $id, $modalParams);

?>

<div class="js-modal-edit-field <?php echo $class; ?>" <?php echo $dataAttribute; ?>>
    <?php echo $modalHtml; ?>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-<?php echo $id;?>">
    <span class="<?php echo !empty($buttonIcon) ? $buttonIcon : 'icon-pen-square'; ?>" aria-hidden="true"></span> <?php echo !empty($buttonText) ? Text::_($buttonText) : Text::_('JACTION_EDIT'); ?>
    </button>

    <!-- TODO Button -->
    <?php if (version_compare(JVERSION, '5.0.0', '>=')) : ?>
        <?php if ($modal['src']) : ?>
    <button type="button" class="btn btn-primary"
            data-joomla-dialog="<?php echo $this->escape(json_encode($modal, JSON_UNESCAPED_SLASHES)); ?>"
            <?php echo isset($checkin) ? 'data-checkin-url="' . Route::_($checkin) . '"' : ''; ?>
            data-close-on-message>
        <span class="<?php echo !empty($buttonIcon) ? $buttonIcon : 'icon-pen-square'; ?>" aria-hidden="true"></span> <?php echo !empty($buttonText) ? Text::_($buttonText) : Text::_('JACTION_EDIT'); ?>
    </button>
        <?php endif; ?>
    <?php endif; ?>
</div>