<?php
/**
 * @package    Joomla.Plugin
 * @subpackage Content.Sismosautotoc
 *
 * @author     Martina Scholz <martina@simplysmart-it.de>
 * @copyright  Copyright (C) 2022 Martina Scholz, All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://simplysmart-it.de
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

?>
<?php (string) HTMLHelper::_('bootstrap.collapse', 'collapseAutotoc', []); ?>
	<div class ="autotoc_alternative <?php echo (($this->params->get('floatend', 1) ? ' align-end' : '')); ?>">
		<button class="btn btn-secondary collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAutotoc" aria-expanded="false" aria-controls="collapseAutotoc">
		<span class="icon-list" aria-hidden="true"></span>
			<?php if ($headline) : ?>
				<span class="autotoc_collapse_heading ps-2"><?php echo Text::_($headline); ?></span>
			<?php endif; ?>
		</button>
		<div class="clearfix"></div>
		<div id="collapseAutotoc" class="autotoc_collapse collapse">
			<?php $path = PluginHelper::getLayoutPath('content', 'sismosautotoc', 'toc'); ?>
			<?php include $path; ?>
		</div>
	</div>


