<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_sismosappointment
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 * @copyright   Copyright (C) 2023 Martina Scholz. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @link        https://simplysmart-it.de
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

HTMLHelper::_('behavior.keepalive');

$fieldsets           = $form->getFieldsets();
$appointmentFieldset = $form->getFieldset('appointment');
$contactFieldset     = $form->getFieldset('contact');
?>

<div id="appointment-message-container" aria-live="polite"></div>
<div class="mod-sismosappointment__form appointment-form" id="appointment-form-container">
    <form id="appointment-form form-validate" method="post" class="form-horizontal well"> 
        <?php if (\array_key_exists('appointment', $fieldsets)) : ?>
            <fieldset class="m-0">
                <?php if (isset($appointmentFieldset->label) && ($legend = trim(Text::_($appointmentFieldset->label))) !== '') : ?>
                    <legend><?php echo $legend; ?></legend>
                <?php endif; ?> 
                <?php echo $form->getField('spacer')->renderField(); ?>
                <?php echo $form->getField('appointment_datetime')->renderField(); ?>
                <?php echo $form->getField('appointment_duration')->renderField(); ?>
            </fieldset>
        <?php endif; ?>
        <fieldset class="m-0 row">
            <?php if ($form->getField('additionalinfo')) : ?>
            <div class="col-12"><?php echo $form->getField('additionalinfo')->renderField(); ?></div>
            <?php endif; ?>
            <div class="col-md-6">
                <?php echo $form->getField('appointment_name')->renderField(); ?>
                <?php echo $form->getField('appointment_email')->renderField(); ?>
            </div>
            <div class="col-md-6">
                <?php if ($form->getField('appointment_phone')) : ?>
                    <?php echo $form->getField('appointment_phone')->renderField(); ?>
                <?php endif; ?>
                <?php echo $form->getField('appointment_message')->renderField(); ?>
            </div>
        </fieldset>
        <?php foreach ($form->getFieldsets() as $fieldset) : ?>
            <?php if ($fieldset->name === 'captcha' && $captchaEnabled) : ?>
                <?php continue; ?>
            <?php endif; ?>
            <?php if ($fieldset->name === 'appointment') : ?>
                <?php continue; ?>
            <?php endif; ?>
            <?php if ($fieldset->name === 'contact') : ?>
                <?php continue; ?>
            <?php endif; ?>
            <?php $fields = $form->getFieldset($fieldset->name); ?>
            <?php if (\count($fields)) : ?>
                <fieldset class="m-0">
                    <?php if (isset($fieldset->label) && ($legend = trim(Text::_($fieldset->label))) !== '') : ?>
                        <legend><?php echo $legend; ?></legend>
                    <?php endif; ?>
                    <?php foreach ($fields as $field) : ?>
                        <?php if ($field->type === 'ConsentNote') : ?>
                            <?php $consentField = $field ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <?php echo $field->renderField(); ?>
                    <?php endforeach; ?>
                </fieldset>
            <?php endif; ?>
        <?php endforeach; ?>
        <?php if ($captchaEnabled) : ?>
            <?php echo $form->renderFieldset('captcha'); ?>
        <?php endif; ?>
        <div id="sismos-appointmentform-alert"></div>
        <div class="control-group">
            <div class="controls">
                <button class="btn btn-primary" type="submit"><?php echo Text::_('MOD_SISMOSAPPOINTMENT_BOOKING_SEND'); ?></button> 
                <?php if (isset($consentField)) : ?>
                    <?php echo $consentField->renderField(); ?>
                <?php endif; ?>
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </form>
</div>
