<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_sismosappointment
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 *
 * @copyright   Copyright (C) 2023 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE
 * @link        https://simplysmart-it.de
 */

namespace SiSmOS\Module\Sismosappointment\Site\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('JPATH_PLATFORM') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_articles_latest
 *
 * @since 1.0.5
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Runs the dispatcher.
     *
     * @return  void
     *
     * @since 1.0.5
     */
    public function dispatch()
    {
        if (!PluginHelper::isEnabled('system', 'sismosappointment')) {
            return;
        }

        $params = $this->module->params;
        if (!$params) {
            return;
        }
        $params = json_decode($this->module->params);

        if (!$params->contactid) {
            return;
        }

        $helper = new \SiSmOS\Module\Sismosappointment\Site\Helper\SismosappointmentHelper(ArrayHelper::fromObject($params));
        if (!$helper->__get('isEnabled')) {
            return;
        }
        parent::dispatch();
    }

    /**
     * Processing the form.
     *
     * @return  json
     *
     * @since 1.0.5
     */
    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $data['moduleclass_sfx'] = ' ' . $data['params']->get('moduleclass_sfx');

        $data['contactId'] = $data['params']->get('contactid');

        // Get CSS Variables from Plugin params
        $data['cssVars'] = "";
        $plgAppointments = PluginHelper::getPlugin('system', 'sismosappointment');
        if ($plgAppointments) {
            $plgParams          = new Registry($plgAppointments->params);
            $data['cssVars']    = ':root {--sismos-appointmentmodal-text: ' . $plgParams->get('textcolor', 'rgba(62, 62, 62, 1)') . ';--sismos-appointmentmodal-highlight: ' . $plgParams->get('datebgcolor', 'rgba(48, 99, 141, 1)') . ';--sismos-appointmentmodal-highlighttext: ' . $plgParams->get('dateselectedtextcolor', 'rgba(255, 255, 255, 1)') . ';}';
        }

        $data['content'] = $data['params']->get('content', '');

        if ($data['params']->get('prepare_content', 1) && $data['content']) {
            PluginHelper::importPlugin('content');
            $data['content'] = HTMLHelper::_('content.prepare', $data['content'], '', 'mod_sismosappointment.content');
        }

        return $data;
    }
}
