// @package   plg_system_sismosappointment  v2.0.2
// @link  https://simplysmart-it.de
// @copyright   (C) 2021 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.


import JoomlaDialog from "joomla.dialog";
"use strict";
if (!window.Joomla) {
  throw new Error("Joomla API was not properly initialised");
}
const sismosappointment_entries = () => {
  initalizeEntryActionButtons(document, ["delSingle", "sendMail", "ics"]);
  const btnCSVExport = document.getElementById("btnExportApmtCSV");
  btnCSVExport.addEventListener("click", () => {
    performListAction("CSVList");
  });
  const btnDeleteO14D = document.getElementById("btnDeleteApmtEntriesO14D");
  btnDeleteO14D.addEventListener("click", async () => {
    let perform = await confirmDialog("O14D");
    if (perform) {
      performListAction("O14D");
    }
  });
  const btnDeleteExpired = document.getElementById("btnDeleteApmtEntriesExpired");
  btnDeleteExpired.addEventListener("click", async () => {
    let perform = await confirmDialog("EXPIRED");
    if (perform) {
      performListAction("EXPIRED");
    }
  });
};
const performListAction = (taskId) => {
  let task_id = document.querySelector('input[name="task"]');
  task_id.value = taskId;
  sendComand();
};
const sendComand = () => {
  const adminform = document.getElementById("contact-form");
  var formData = new FormData(adminform);
  var jsonData = new URLSearchParams(Array.from(formData)).toString();
  let task_id = document.querySelector('input[name="task"]');
  let responseFormat = "json";
  if (task_id.value === "ics" || task_id.value === "CSVList") {
    responseFormat = "raw";
  }
  const paths = Joomla.getOptions("system.paths");
  const uri = `${paths ? `${paths.base}/index.php` : window.location.pathname}?option=com_ajax&plugin=sismosappointment&group=system&format=${responseFormat}`;
  Joomla.request({
    method: "POST",
    url: uri,
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    data: jsonData,
    promise: true,
    onBefore: function(xhr) {
      if (task_id.value === "ics" || task_id.value === "CSVList") {
        console.log("ICS Export");
        xhr.responseType = "blob";
      }
    }
  }).then((xhr) => {
    console.log("handle response indivudally");
    if (task_id.value === "ics" || task_id.value === "CSVList") {
      handleResponseExport(xhr, task_id);
    } else {
      handleResponse(xhr, task_id);
    }
    document.querySelector('input[name="task"]').value = "";
  }).catch((err) => {
    console.log("Error on load???!!!");
    console.log(err);
    Joomla.renderMessages({ error: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR")] });
  });
};
const handleResponse = (xhr, task_id) => {
  let response = JSON.parse(xhr.responseText);
  console.log(response);
  if (response.success) {
    console.log(task_id.value);
    switch (task_id.value) {
      case "loadEntryForm":
        var entrydata = response.data["entryData"];
        var formContainer = document.querySelector("#appointmentEditForm");
        Object.keys(entrydata).forEach((key) => {
          var input = formContainer.querySelector('[name="' + key + '"]');
          if (input) {
            switch (input.nodeName) {
              case "INPUT":
                input.value = entrydata[key];
                break;
              case "SELECT":
                input.value = entrydata[key];
                break;
              case "TEXTAREA":
                input.textContent = entrydata[key];
                break;
              default:
            }
          }
        });
        if (dialog) {
          dialog.querySelector(".load-content-container").style.visibility = "";
          dialog.querySelector(".form-loader").style.display = "none";
        }
        break;
      case "sendMail":
        if (response.data["send"]) {
          alert(Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_SUCCESS"));
        } else {
        }
        break;
      case "ics":
        break;
      default:
        if (response.data["reload"]) {
          var table = document.querySelector("table#appointment-entries-table");
          var tbody = table.querySelector("tbody");
          tbody.innerHTML = response.data["FieldEntries"];
          initalizeEntryActionButtons(tbody, ["delSingle", "sendMail", "ics"]);
          if (task_id.value === "submitEntryForm") {
            if (dialog) {
              dialog.close();
            }
            Joomla.renderMessages({ success: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UPDATE_SUCCESS")] });
          }
        } else {
          Joomla.renderMessages({ warning: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_NORELOADREQUESTED_WARNING")] });
        }
        console.log(response);
        break;
    }
  } else {
    Joomla.renderMessages({ error: [Joomla.Text._(response.message)] });
  }
};
const handleResponseExport = (xhr, task_id) => {
  if (xhr.status === 200) {
    if (task_id.value !== "ics" && task_id.value !== "CSVList") {
      Joomla.renderMessages({ error: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR")] });
      return;
    }
    const disposition = xhr.getResponseHeader("content-disposition");
    let filename = "";
    if (disposition && disposition.indexOf("attachment") !== -1) {
      var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
      var matches = filenameRegex.exec(disposition);
      if (matches != null && matches[1]) {
        filename = matches[1].replace(/['"]/g, "");
      }
    }
    let result = xhr.response;
    let a = document.createElement("a");
    a.style = "display: none";
    document.body.appendChild(a);
    let myurl = window.URL.createObjectURL(result);
    a.href = myurl;
    a.download = filename;
    a.click();
    window.URL.revokeObjectURL(myurl);
    a.remove();
  } else {
    Joomla.renderMessages({ error: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR")] });
  }
};
const dialog = new JoomlaDialog({
  popupType: "inline",
  preferredParent: "form",
  textHeader: Joomla.JText._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EDIT_DIALOG_TITLE"),
  src: "#appointmentEditTemplate",
  height: "fit-content"
});
dialog.addEventListener("joomla-dialog:close", () => {
  dialog.destroy();
  let systemMessageContainer = document.getElementById("system-message-container-origin");
  if (systemMessageContainer) {
    systemMessageContainer.id = "system-message-container";
  }
});
dialog.addEventListener("joomla-dialog:open", (event) => {
  let popup = event.target;
  let popupBody = popup.querySelector(".joomla-dialog-body");
  if (!dialog.relatedTarget) {
    Joomla.renderMessages({ error: [Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR")] });
    dialog.destroy();
    return false;
  }
  document.querySelector('input[name="task"]').value = "loadEntryForm";
  document.querySelector('input[name="sismosAptmaActionId"]').value = dialog.relatedTarget.dataset.id;
  sendComand();
  let systemMessageContainer = document.getElementById("system-message-container");
  if (systemMessageContainer) {
    let newMessageContainer = systemMessageContainer.cloneNode(true);
    systemMessageContainer.id = "system-message-container-origin";
    popupBody.prepend(newMessageContainer);
  }
  let submitEdit = popupBody.querySelector('button[data-sismosappointemnt="edit-save"]');
  submitEdit.addEventListener("click", (event2) => {
    event2.preventDefault();
    let task_id = document.querySelector('input[name="task"]');
    task_id.value = "submitEntryForm";
    sendComand();
  });
  let cancelEdit = popupBody.querySelector('button[data-sismosappointemnt="edit-cancel"]');
  cancelEdit.addEventListener("click", (event2) => {
    event2.preventDefault();
    let task_id = document.querySelector('input[name="task"]');
    task_id.value = "";
    dialog.close();
  });
});
const initalizeEntryActionButtons = (parent, tasksToSearch) => {
  tasksToSearch.forEach(function(taskToSearch) {
    let buttons = parent.querySelectorAll('[data-task="' + taskToSearch + '"]');
    buttons.forEach(function(button) {
      button.addEventListener("click", async function(event) {
        let actionButton = event.currentTarget;
        let perform = await confirmDialog(taskToSearch);
        console.log("Result of waited dialog: " + perform);
        if (perform) {
          performEntryAction(actionButton);
        }
      });
    });
  });
  let toggleDialog = parent.querySelectorAll('[data-sismosappointment="dialog"]');
  toggleDialog.forEach(function(toggle) {
    toggle.addEventListener("click", function(event) {
      dialog.relatedTarget = event.currentTarget;
      dialog.show();
    });
  });
};
const confirmDialog = async (task) => {
  return new Promise((resolve) => {
    switch (task) {
      case "delSingle":
        JoomlaDialog.confirm(Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_ITEM_CONFIRM")).then((result) => {
          resolve(result);
        });
        break;
      case "sendMail":
        JoomlaDialog.confirm(Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_ITEM_CONFIRM")).then((result) => {
          resolve(result);
        });
        break;
      case "O14D":
        JoomlaDialog.confirm(Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_BLOCKED_CONFIRM")).then((result) => {
          resolve(result);
        });
        break;
      case "EXPIRED":
        JoomlaDialog.confirm(Joomla.Text._("PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_EXPIRED_CONFIRM")).then((result) => {
          resolve(result);
        });
        break;
      case "ics":
        resolve(true);
        break;
      default:
        resolve(false);
        break;
    }
  });
};
const performEntryAction = (target) => {
  console.log("Action perform!");
  let task_id = document.querySelector('input[name="task"]');
  task_id.value = target.dataset.task;
  let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
  action_id.value = target.dataset.id;
  sendComand();
};
((document2) => {
  document2.addEventListener("DOMContentLoaded", sismosappointment_entries);
})(document);
