// @package   mod_sismosappointment  v2.0.2
// @link  https://simplysmart-it.de
// @copyright   (C) 2021 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.


import JoomlaDialog from "joomla.dialog";
"use strict";
if (!window.Joomla) {
  throw new Error("Joomla API was not properly initialised");
}
const initSismosAppointment = () => {
  var toggleButtons = document.querySelectorAll('[data-sismosappointment="dialog"]');
  toggleButtons.forEach(function(toggle) {
    toggle.addEventListener("click", function(event) {
      dialog.relatedTarget = event.currentTarget;
      dialog.show();
    });
  });
  document.removeEventListener("DOMContentLoaded", initSismosAppointment);
};
const ErrorHandling = (parent) => {
  const reloadMsg = Joomla.JText._("MOD_APPOINTMENT_RELOAD_ACTION");
  const loadErrMsg = Joomla.JText._("MOD_APPOINTMENT_LOAD_ERR_MESSAGE");
  if (!parent) {
    let error = {
      error: [Joomla.Text._("MOD_APPOINTMENT_LOAD_ERR_MESSAGE")]
    };
    Joomla.renderMessages(error, void 0, true);
    return false;
  }
  var errorNode = parent.querySelector(".appointmentErrContainer");
  if (!errorNode) {
    errorNode = document.createElement("div");
    errorNode.classList.add("appointmentErrContainer");
    errorNode.style.textAlign = "center";
    parent.appendChild(errorNode);
  }
  let popupLoader = parent.querySelector(".form-loader");
  if (popupLoader) {
    popupLoader.parentNode.removeChild(popupLoader);
  }
  errorNode.innerHTML = "<p>" + loadErrMsg + '</p><button type="button" class="btn btn-secondary" id="errReloadPageApmt"><span class="icon-loop" aria-hidden="true"></span> ' + reloadMsg + "</button>";
  let btnReload = errorNode.querySelector("#errReloadPageApmt");
  btnReload.addEventListener("click", () => {
    window.location.reload();
  });
};
const dialog = new JoomlaDialog({
  popupType: "inline",
  textHeader: Joomla.JText._("MOD_SISMOSAPPOINTMENT_BOOKING_DEFAULT_LABEL"),
  popupContent: '<div class="form-loader fs-2 position-absolute top-50 start-50 translate-middle"><i class="fa fa-spinner fa-spin"></i></div>'
});
dialog.addEventListener("joomla-dialog:close", () => {
  dialog.destroy();
  let systemMessageContainer = document.getElementById("system-message-container-origin");
  if (systemMessageContainer) {
    systemMessageContainer.id = "system-message-container";
  }
});
dialog.addEventListener("joomla-dialog:open", (event) => {
  let popup = event.target;
  let popupBody = popup.querySelector(".joomla-dialog-body");
  let popupTitle = popup.querySelector(".joomla-dialog-header>h3");
  if (popupTitle) {
    popupTitle.hidden = true;
  }
  let utcoffset = (/* @__PURE__ */ new Date()).getTimezoneOffset();
  if (!dialog.relatedTarget) {
    ErrorHandling(popupBody);
    return false;
  }
  let contactId = dialog.relatedTarget.dataset.contact;
  let moduleId = dialog.relatedTarget.dataset.mod;
  let formData = new FormData();
  formData.append("getSismosappointmentFormAjax", 1);
  formData.append("jform[tzoffset]", utcoffset);
  formData.append("jform[moduleId]", moduleId);
  formData.append("jform[contactId]", contactId);
  let jsonData = new URLSearchParams(Array.from(formData)).toString();
  const paths = Joomla.getOptions("system.paths");
  const uri = `${paths ? `${paths.root}/index.php` : window.location.pathname}?option=com_ajax&module=sismosappointment&method=getAppointmentForm&format=json`;
  Joomla.request({
    method: "POST",
    // url : dialog.requestUrl,
    url: uri,
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    data: jsonData,
    onSuccess: function(response, xhr) {
      try {
        const parsed = JSON.parse(response);
        let head = document.getElementsByTagName("head")[0];
        if (parsed.data.modalTitle) {
          dialog.textHeader = parsed.data.modalTitle;
          if (popupTitle) {
            popupTitle.textContent = parsed.data.modalTitle;
          }
        }
        if (popupTitle) {
          popupTitle.hidden = false;
        }
        if (parsed.data.scripts) {
          Object.keys(parsed.data.scripts).forEach((key) => {
            var script = head.querySelector('script[data-asset-name="' + key + '"]');
            var newscript = document.createElement("script");
            newscript.src = parsed.data.scripts[key][0];
            newscript.setAttribute("data-asset-name", key);
            if (script) {
              script.remove();
            }
            head.appendChild(newscript);
          });
        }
        if (parsed.data.styles) {
          Object.keys(parsed.data.styles).forEach((key) => {
            if (parsed.data.styles[key][0] == "" && !head.querySelector('[data-asset-name="' + key + '"]') && parsed.data.styles[key]?.options?.inline) {
              var inlineStyle = document.createElement("style");
              inlineStyle.setAttribute("data-asset-name", key);
              inlineStyle.innerHTML = parsed.data.styles[key].options?.content ?? "";
              head.appendChild(inlineStyle);
            }
            var stylesheet = head.querySelector('link[data-asset-name="' + key + '"]');
            if (!stylesheet && parsed.data.styles[key][0] != "") {
              stylesheet = document.createElement("link");
              stylesheet.setAttribute("data-asset-name", key);
              stylesheet.href = parsed.data.styles[key][0];
              stylesheet.rel = "stylesheet";
              head.appendChild(stylesheet);
            }
          });
        }
        if (!popupBody) {
          dialog.destroy();
          ErrorHandling(popupBody);
          return false;
        }
        let popupLoader = popupBody.querySelector(".form-loader");
        popupLoader.parentNode.removeChild(popupLoader);
        popupBody.insertAdjacentHTML("afterbegin", parsed.data["form"]);
        sismosappointment_loadedForm(popup);
        if (document.getElementById("sismos-appointmentform-alert")) {
          Joomla.removeMessages("#sismos-appointmentform-alert");
        }
      } catch (e) {
        console.log("Error on load???!!!");
        console.log(e);
        ErrorHandling(popupBody);
      }
    },
    onError: (xhr) => {
      console.log("Request failed.  Returned status of " + xhr.status);
      if (popupBody) {
        ErrorHandling(popupBody);
      } else {
      }
      console.log(xhr.response);
    }
  });
});
const sismosappointment_loadedForm = (popup) => {
  let systemMessageContainer = document.getElementById("system-message-container");
  let popupBody = popup.querySelector(".joomla-dialog-body");
  if (systemMessageContainer) {
    let newMessageContainer = systemMessageContainer.cloneNode(true);
    systemMessageContainer.id = "system-message-container-origin";
    if (popupBody.querySelector("#sismos-appointmentform-alert")) {
      popupBody.querySelector("#sismos-appointmentform-alert").replaceWith(newMessageContainer);
    } else {
      popupBody.prepend(newMessageContainer);
    }
  }
  let form = popup.querySelector("form");
  let bookingTab = popup.querySelector("#booking-tab");
  let next = popup.querySelector("#booking-next");
  let prev = popup.querySelector("#booking-prev");
  let activeAppointmentDate = bookingTab.querySelector("button.booking-tab-slider__anchor.active");
  let activeDatePos = activeAppointmentDate.getBoundingClientRect().left - bookingTab.getBoundingClientRect().left;
  let tabEl = bookingTab.querySelectorAll('button[data-bs-toggle="tab"]');
  if (activeDatePos > 120) {
    bookingTab.scrollLeft = bookingTab.scrollLeft + (activeDatePos - 120);
  }
  let pos = { top: 0, left: 0, x: 0, y: 0 };
  const mouseDownHandler = (e) => {
    bookingTab.style.cursor = "grabbing";
    bookingTab.style.userSelect = "none";
    pos = {
      // The current scroll
      left: bookingTab.scrollLeft,
      // Get the current mouse position
      x: e.clientX
    };
    document.addEventListener("mousemove", mouseMoveHandler);
    document.addEventListener("mouseup", mouseUpHandler);
  };
  const mouseMoveHandler = (e) => {
    const dx = e.clientX - pos.x;
    bookingTab.scrollLeft = pos.left - dx;
  };
  const mouseUpHandler = () => {
    document.removeEventListener("mousemove", mouseMoveHandler);
    document.removeEventListener("mouseup", mouseUpHandler);
    bookingTab.style.cursor = "grab";
    bookingTab.style.removeProperty("user-select");
  };
  const moveNext = function() {
    bookingTab.scrollLeft = bookingTab.scrollLeft + 110;
  };
  const movePrev = function() {
    bookingTab.scrollLeft = bookingTab.scrollLeft - 110;
  };
  bookingTab.addEventListener(
    "focus",
    (event) => {
      if (event.target.getBoundingClientRect().right - bookingTab.getBoundingClientRect().right > 0) {
        bookingTab.scrollLeft = bookingTab.scrollLeft + (event.target.getBoundingClientRect().right - bookingTab.getBoundingClientRect().right);
      } else if (event.target.getBoundingClientRect().left - bookingTab.getBoundingClientRect().left < 0) {
        bookingTab.scrollLeft = bookingTab.scrollLeft + (event.target.getBoundingClientRect().left - bookingTab.getBoundingClientRect().left);
      }
    },
    true
  );
  bookingTab.addEventListener("mousedown", mouseDownHandler);
  next.addEventListener("click", moveNext);
  prev.addEventListener("click", movePrev);
  tabEl.forEach(function(elTab) {
    elTab.addEventListener("shown.bs.tab", function(ev) {
      var targetId = ev.target.getAttribute("data-bs-target");
      form.querySelector(targetId).querySelectorAll('input[type="radio"]').forEach(function(inputEl) {
        inputEl.required = true;
        inputEl.disabled = false;
      });
      var relatedtargetId = ev.relatedTarget.getAttribute("data-bs-target");
      form.querySelector(relatedtargetId).querySelectorAll('input[type="radio"]').forEach(function(inputEl) {
        inputEl.required = false;
        inputEl.disabled = true;
        inputEl.checked = false;
      });
    });
  });
  document.formvalidator.setHandler("phone", (value) => {
    const regex = /^\+{0,2}([\-\. ])?(\(?\d{0,4}\))?([\/\-\. ])?\(?\d{0,4}\)?([\/\-\. ])?\d{3}([\/\-\. ])?\d{4}/;
    return regex.test(value);
  });
  document.formvalidator.attachToForm(form);
  popup.querySelector('button[type="submit"]').addEventListener("click", function(e) {
    e.preventDefault();
    if (document.formvalidator.isValid(form)) {
      submitForm(form);
    }
  });
  const reload_js = () => {
    var head = document.getElementsByTagName("head")[0];
    var scripts = [head.querySelector('script[data-asset-name="short-and-sweet"]')];
    scripts.forEach(function(script) {
      if (script) {
        var newscript = document.createElement("script");
        newscript.src = script.src;
        newscript.defer = script.defer;
        script.remove();
        head.appendChild(newscript);
      }
    });
  };
  reload_js();
};
const submitForm = (form) => {
  var formData = new FormData(form);
  formData.append("jform[tzoffset]", (/* @__PURE__ */ new Date()).getTimezoneOffset());
  var jsonData = "submitSismosappointmentFormAjax=1&" + new URLSearchParams(Array.from(formData)).toString();
  const paths = Joomla.getOptions("system.paths");
  const uri = `${paths ? `${paths.root}/index.php` : window.location.pathname}?option=com_ajax&module=sismosappointment&method=submitForm&format=json`;
  Joomla.request({
    method: "post",
    url: uri,
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    data: jsonData,
    onSuccess: function(response, xhr) {
      try {
        var responseData = JSON.parse(response);
        if (responseData.success) {
          form.style.display = "none";
          Joomla.renderMessages({ success: [Joomla.Text._("MOD_APPOINTMENT_REQUEST_SUCCESS")] }, "#appointment-message-container", false);
          if (!responseData.data["mail"]) {
            Joomla.renderMessages({ error: [Joomla.Text._("MOD_APPOINTMENT_MAIL_ERR_MESSAGE")] }, "#appointment-message-container", false);
          }
        } else {
          Joomla.renderMessages({ error: [Joomla.Text._(responseData.message)] }, "#appointment-message-container");
          if (responseData.data["field"]) {
            var field = form.querySelector(".form_appointment_datetime_field");
            field.outerHTML = responseData.data["field"];
            sismosappointment_loadedForm(form.parentNode.closest("joomla-dialog"));
          } else {
            form.style.display = "none";
            ErrorHandling(form.parentNode);
          }
        }
      } catch (err) {
        console.log(err);
        form.style.display = "none";
        ErrorHandling(form.parentNode);
      }
    },
    onError: (xhr) => {
      console.log("Request failed.  Returned status of " + xhr.status);
      console.log(xhr.response);
      ErrorHandling(form.parentNode);
      form.style.display = "none";
    }
  });
};
((document2) => {
  document2.addEventListener("DOMContentLoaded", initSismosAppointment);
})(document);
