<?php

/**
 * @package     lib_sismos
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 *
 * @copyright   Copyright (C) 2023 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE
 * @link        https://simplysmart-it.de
 */

namespace Sismos\Library\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\SubformField;
use Joomla\CMS\Layout\FileLayout;

// phpcs:disable PSR1.Files.SideEffects
\defined('JPATH_PLATFORM') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * The Field to load the form inside current form
 *
 * @since  1.0.3
 */
class SismossubformField extends SubformField
{
	/**
	 * The form field type.
	 * @var    string
	 */
	protected $type = 'Sismossubform';

	/**
	 * Form source
	 * @var string
	 */
	protected $formsource;

	/**
	 * Minimum items in repeat mode
	 * @var integer
	 */
	protected $min = 0;

	/**
	 * Maximum items in repeat mode
	 * @var integer
	 */
	protected $max = 1000;

	/**
	 * Layout to render the form
	 * @var  string
	 */
	protected $layout = 'joomla.form.field.subform.default';

	/**
	 * Whether group subform fields by it`s fieldset
	 * @var boolean
	 */
	protected $groupByFieldset = false;

	/**
	 * Which buttons to show in multiple mode
	 * @var array $buttons
	 */
	protected $buttons = ['add' => true, 'remove' => true, 'move' => true];

	/**
	 * Allow to override renderer include paths in child fields
	 *
	 * @return  array
	 *
	 * @since   3.5
	 */
	protected function getLayoutPaths()
	{
		$renderer = new FileLayout($this->layout);

		$renderer->setIncludePaths(parent::getLayoutPaths());

		$renderer->addIncludePaths(dirname(__DIR__, 2) . '/layouts');

		$paths = $renderer->getIncludePaths();

		return $paths;
	}
}
