<?php

/**
 * @package     lib_sismos
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 *
 * @copyright   Copyright (C) 2023 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE
 * @link        https://simplysmart-it.de
 */

namespace Sismos\Library\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('JPATH_PLATFORM') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Form Field class for the Joomla Platform.
 *
 * Provides a pop up date picker linked to a button.
 * Optionally may be filtered to use user's or server's time zone.
 *
 * @since  1.0.2
 */
class SismosinfoField extends FormField
{

	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.0.2
	 */
	protected $type = 'sismosinfo';

	/**
	 * Method to get the field input markup for a spacer.
	 * The spacer does not have accept input.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.0.2
	 */
	protected function getInput()
	{
		return ' ';
	}

	/**
	 * Method to get the field label markup for a spacer.
	 * Use the label text or name from the XML element as the spacer or
	 * Use a hr="true" to automatically generate plain hr markup
	 *
	 * @return  string  The field label markup.
	 *
	 * @since   1.0.2
	 */
	protected function getLabel()
	{
		$html = [];

		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->registerAndUseStyle('sismos.info', 'lib_sismos/sismosinfo.css')
			->useStyle('fontawesome');
		$html[] = '<figure class="snip1578">
					<img src="' . Uri::root() . '/media/lib_sismos/images/sismos_pic1.svg" alt="Bitmoji SimplySmart-OpenSource - Martina Scholz" width="auto" height="120"/>
					<figcaption>						
						<p>Made With <i class="fas fa-heart"></i></p>
						<p>SimplySmart <i class="fas fa-magic"></i> OpenSource</p>
						<div class="icons">
							<a href="www.linkedin.com/in/scholz-martina" title="LinkedIn" target="_blank"><i class="fab fa-linkedin"></i></a>
							<a href="https://github.com/SimplySmart-IT" title="Github" target="_blank"> <i class="fab fa-github-square"></i></a>
							<a href="https://simplysmart-it.de" title="simplysmart-it.de" target="_blank"><i class="fa fa-globe"></i></a>
						</div>
					</figcaption>
				</figure>';

		$html[] = '<div class="sismit-logo">
						<svg width="343" height="104" version="1.0" viewBox="0 0 287.25 78" xmlns="http://www.w3.org/2000/svg" zoomAndPan="magnify"><defs><clipPath id="96dbe98cbe"><path d="m130.02 11.523h104.77v40.578h-104.77z"/></clipPath><clipPath id="4295b91834"><rect width="119" height="47"/></clipPath><clipPath id="ce9f9bb691"><rect width="116" height="17"/></clipPath><clipPath id="aaafb43095"><rect width="40" height="45"/></clipPath></defs><g id="smart-bg" class="surface"><g clip-path="url(#96dbe98cbe)"><path d="m130.02 11.523h104.77v40.578h-104.77z"/></g></g><g id="smart" class="brand"><g transform="translate(131 7)"><g><g transform="translate(88.916 36.49)"><path d="m7.375-22.875v4.4531h3.4844v2.4844h-3.4844v11.188c0 0.86719 0.17578 1.4766 0.53125 1.8281 0.36328 0.34375 0.83594 0.51562 1.4219 0.51562 0.30078 0 0.63281-0.019531 1-0.0625 0.36328-0.050781 0.67188-0.10938 0.92188-0.17188l0.46875 2.2969c-0.32422 0.21094-0.79297 0.375-1.4062 0.5-0.60547 0.13281-1.2148 0.20312-1.8281 0.20312-1.3672 0-2.4531-0.41016-3.2656-1.2344-0.80469-0.82031-1.2031-2.1133-1.2031-3.875v-11.188h-2.9062v-2.4844h2.9062v-4.4531z"/></g><g transform="translate(74.493 36.49)"><path d="m1.5156-16.266v-2.1562h5.7656l0.32812 2.6719c0.51953-0.94531 1.1602-1.6875 1.9219-2.2188 0.76953-0.53125 1.6484-0.79688 2.6406-0.79688 0.25781 0 0.53125 0.023437 0.8125 0.0625 0.28125 0.042969 0.49219 0.085937 0.64062 0.125l-0.4375 3.1094-1.9219-0.09375c-0.88672 0-1.6328 0.21094-2.2344 0.625-0.59375 0.40625-1.0586 0.98438-1.3906 1.7344v10.578l2.7812 0.48438v2.1406h-8.9062v-2.1406l2.7812-0.48438v-13.156z"/></g><g transform="translate(55.284 36.49)"><path d="m13.531 0c-0.09375-0.5-0.17188-0.94531-0.23438-1.3438-0.054687-0.39453-0.089844-0.78906-0.10938-1.1875-0.65625 0.82422-1.4688 1.5117-2.4375 2.0625-0.96875 0.55078-2.0078 0.82812-3.1094 0.82812-1.918 0-3.375-0.46875-4.375-1.4062s-1.5-2.2539-1.5-3.9531c0-1.75 0.70703-3.0977 2.125-4.0469 1.4141-0.94531 3.3516-1.4219 5.8125-1.4219h3.4531v-2.1562c0-1.0703-0.33984-1.9219-1.0156-2.5469-0.67969-0.63281-1.625-0.95312-2.8438-0.95312-0.84375 0-1.5898 0.10938-2.2344 0.32812-0.63672 0.21094-1.1523 0.5-1.5469 0.875l-0.35938 1.9531h-2.5781v-3.5781c0.83203-0.67578 1.8438-1.2109 3.0312-1.6094 1.1953-0.40625 2.4922-0.60938 3.8906-0.60938 2.0938 0 3.7852 0.53906 5.0781 1.6094 1.2891 1.0625 1.9375 2.5898 1.9375 4.5781v8.8594 0.70312c0.007813 0.23047 0.023437 0.46094 0.046875 0.6875l1.375 0.1875v2.1406zm-5.3906-2.4531c1.1133 0 2.1289-0.26562 3.0469-0.79688 0.91406-0.53125 1.5703-1.1719 1.9688-1.9219v-3.0312h-3.5625c-1.375 0-2.4648 0.32031-3.2656 0.95312-0.80469 0.63672-1.2031 1.4062-1.2031 2.3125 0 0.80469 0.25 1.418 0.75 1.8438 0.5 0.42969 1.2539 0.64062 2.2656 0.64062z"/></g><g transform="translate(22.333 36.49)"><path d="m0.84375-2.1406 2.7812-0.48438v-13.156l-2.7812-0.48438v-2.1562h5.7969l0.21875 2.3906c0.59375-0.86328 1.3516-1.5352 2.2812-2.0156 0.9375-0.47656 2.0156-0.71875 3.2344-0.71875 1.2266 0 2.2812 0.28906 3.1562 0.85938 0.88281 0.5625 1.5469 1.4141 1.9844 2.5469 0.58203-1.0391 1.3477-1.8672 2.2969-2.4844 0.95703-0.61328 2.0703-0.92188 3.3438-0.92188 1.8828 0 3.3672 0.64844 4.4531 1.9375 1.0938 1.2812 1.6406 3.2188 1.6406 5.8125v8.3906l2.7812 0.48438v2.1406h-8.9219v-2.1406l2.7812-0.48438v-8.4219c0-1.8203-0.3125-3.1094-0.9375-3.8594-0.625-0.75781-1.5547-1.1406-2.7812-1.1406-1.168 0-2.1094 0.41406-2.8281 1.2344-0.71094 0.82422-1.1172 1.8594-1.2188 3.1094v9.0781l2.7656 0.48438v2.1406h-8.9062v-2.1406l2.7812-0.48438v-8.4219c0-1.7266-0.32422-2.9922-0.96875-3.7969-0.63672-0.80078-1.5625-1.2031-2.7812-1.2031-1.0234 0-1.8594 0.21484-2.5156 0.64062-0.65625 0.41797-1.1641 1.0078-1.5156 1.7656v11.016l2.7656 0.48438v2.1406h-8.9062z"/></g><g transform="translate(1.0978 36.49)"><path d="m19.156-17.469h-2.5312l-0.64062-3.5469c-0.51172-0.42578-1.1953-0.78125-2.0469-1.0625-0.84375-0.28906-1.8281-0.4375-2.9531-0.4375-1.7812 0-3.1523 0.38281-4.1094 1.1406-0.94922 0.75-1.4219 1.7344-1.4219 2.9531 0 1.0742 0.48438 1.9766 1.4531 2.7031 0.96875 0.71875 2.5352 1.3516 4.7031 1.8906 2.6133 0.64844 4.5977 1.6016 5.9531 2.8594 1.3516 1.2617 2.0312 2.8242 2.0312 4.6875 0 2-0.8125 3.6094-2.4375 4.8281-1.625 1.2109-3.7578 1.8125-6.3906 1.8125-1.9062 0-3.6055-0.3125-5.0938-0.9375-1.4805-0.625-2.6836-1.4414-3.6094-2.4531v-4.6094h2.5156l0.65625 3.5469c0.64453 0.54297 1.4141 0.98438 2.3125 1.3281 0.89453 0.33594 1.9688 0.5 3.2188 0.5 1.6875 0 3.0195-0.35156 4-1.0625 0.98828-0.71875 1.4844-1.6914 1.4844-2.9219 0-1.1328-0.42969-2.082-1.2812-2.8438-0.85547-0.76953-2.3594-1.4141-4.5156-1.9375-2.625-0.625-4.6797-1.5391-6.1562-2.75-1.4688-1.2188-2.2031-2.75-2.2031-4.5938 0-1.9375 0.82031-3.5508 2.4688-4.8438 1.6445-1.2891 3.7852-1.9375 6.4219-1.9375 1.7383 0 3.3164 0.30469 4.7344 0.90625 1.4258 0.59375 2.5703 1.3125 3.4375 2.1562z"/></g></g></g></g><g id="simply" class="surface"><g transform="translate(11 7)"><g clip-path="url(#4295b91834)"><g><g transform="translate(.51909 36.516)"><path d="m19.172-17.484h-2.5469l-0.625-3.5312c-0.51172-0.4375-1.1953-0.79688-2.0469-1.0781-0.85547-0.28125-1.8438-0.42188-2.9688-0.42188-1.7812 0-3.1523 0.38281-4.1094 1.1406-0.94922 0.75-1.4219 1.7305-1.4219 2.9375 0 1.0859 0.48438 1.9844 1.4531 2.7031s2.5391 1.3555 4.7188 1.9062c2.6016 0.64844 4.582 1.6016 5.9375 2.8594 1.3633 1.2617 2.0469 2.8242 2.0469 4.6875 0 2-0.82031 3.6094-2.4531 4.8281-1.625 1.2109-3.7578 1.8125-6.3906 1.8125-1.9062 0-3.6055-0.3125-5.0938-0.9375-1.4805-0.625-2.6836-1.4414-3.6094-2.4531v-4.625h2.5156l0.65625 3.5625c0.64453 0.54297 1.4141 0.98438 2.3125 1.3281 0.89453 0.33594 1.9688 0.5 3.2188 0.5 1.6953 0 3.0352-0.35156 4.0156-1.0625 0.97656-0.71875 1.4688-1.6914 1.4688-2.9219 0-1.1328-0.42969-2.082-1.2812-2.8438-0.84375-0.76953-2.3516-1.4219-4.5156-1.9531-2.6172-0.625-4.6641-1.5391-6.1406-2.75-1.4805-1.2188-2.2188-2.7422-2.2188-4.5781 0-1.9453 0.82031-3.5625 2.4688-4.8438 1.6445-1.2891 3.7852-1.9375 6.4219-1.9375 1.7383 0 3.3203 0.29688 4.75 0.89062 1.4258 0.59375 2.5703 1.3203 3.4375 2.1719z"/></g><g transform="translate(21.754 36.516)"><path d="m1.5156-2.1406 2.7812-0.48438v-13.172l-2.7812-0.46875v-2.1719h6.1406v15.812l2.7656 0.48438v2.1406h-8.9062zm6.1406-21.016h-3.3594v-3.4219h3.3594z"/></g><g transform="translate(33.215 36.516)"><path d="m0.85938-2.1406 2.7656-0.48438v-13.172l-2.7656-0.46875v-2.1719h5.7812l0.21875 2.4062c0.59375-0.875 1.3516-1.5508 2.2812-2.0312 0.9375-0.47656 2.0195-0.71875 3.25-0.71875 1.2188 0 2.2656 0.28906 3.1406 0.85938 0.88281 0.5625 1.5508 1.418 2 2.5625 0.58203-1.0508 1.3477-1.8828 2.2969-2.5 0.95703-0.61328 2.0703-0.92188 3.3438-0.92188 1.8828 0 3.3672 0.64844 4.4531 1.9375 1.0938 1.293 1.6406 3.2344 1.6406 5.8281v8.3906l2.7812 0.48438v2.1406h-8.9219v-2.1406l2.7656-0.48438v-8.4375c0-1.8125-0.3125-3.0938-0.9375-3.8438-0.625-0.75781-1.5469-1.1406-2.7656-1.1406-1.1797 0-2.1211 0.41406-2.8281 1.2344-0.71094 0.82422-1.1211 1.8594-1.2344 3.1094v9.0781l2.7812 0.48438v2.1406h-8.9062v-2.1406l2.7656-0.48438v-8.4375c0-1.7188-0.32422-2.9766-0.96875-3.7812-0.63672-0.80078-1.5625-1.2031-2.7812-1.2031-1.0234 0-1.8594 0.21484-2.5156 0.64062-0.65625 0.41797-1.1641 1.0078-1.5156 1.7656v11.016l2.7812 0.48438v2.1406h-8.9062z"/></g><g transform="translate(66.165 36.516)"><path d="m1.1094 4.9219 2.7812-0.46875v-20.25l-2.7812-0.46875v-2.1719h5.6562l0.29688 2.25c0.61328-0.84375 1.3594-1.4844 2.2344-1.9219 0.88281-0.44531 1.9102-0.67188 3.0781-0.67188 2.2812 0 4.0508 0.90625 5.3125 2.7188 1.2695 1.8125 1.9062 4.2109 1.9062 7.1875v0.35938c0 2.6562-0.63672 4.8047-1.9062 6.4375-1.2734 1.625-3.0273 2.4375-5.2656 2.4375-1.1367 0-2.1367-0.1875-3-0.5625-0.85547-0.38281-1.5859-0.95312-2.1875-1.7031v6.3594l2.7812 0.46875v2.1719h-8.9062zm15.109-13.797c0-2.1016-0.41406-3.8203-1.2344-5.1562-0.8125-1.3438-2.0273-2.0156-3.6406-2.0156-0.94922 0-1.7656 0.21875-2.4531 0.65625-0.67969 0.42969-1.2305 1.0156-1.6562 1.7656v8.9688c0.42578 0.76172 0.97266 1.3516 1.6406 1.7656 0.67578 0.41797 1.5078 0.625 2.5 0.625 1.5938 0 2.7969-0.57812 3.6094-1.7344 0.82031-1.1562 1.2344-2.6602 1.2344-4.5156z"/></g><g transform="translate(87.281 36.516)"><path d="m1.0625-24.406v-2.1719h6.125v23.953l2.7812 0.48438v2.1406h-8.9062v-2.1406l2.7656-0.48438v-21.312z"/></g><g transform="translate(98.265 36.516)"><path d="m19.031-16.266-1.6562 0.25-7.0156 18.844c-0.46875 1.2383-1.1406 2.3164-2.0156 3.2344-0.875 0.91406-2.0469 1.375-3.5156 1.375-0.27344 0-0.61719-0.03125-1.0312-0.09375-0.41797-0.0625-0.74219-0.12109-0.96875-0.17188l0.34375-2.6406c-0.074219-0.011719 0.125 0 0.59375 0.03125 0.47656 0.03125 0.78125 0.046875 0.90625 0.046875 0.70703 0 1.2812-0.30859 1.7188-0.92188 0.44531-0.61719 0.83594-1.3281 1.1719-2.1406l0.79688-1.9062-6.0781-15.641-1.6875-0.26562v-2.1719h7.4531v2.1719l-2.0781 0.34375 3.1875 9.0938 0.60938 2.3438h0.09375l3.8438-11.438-2.0938-0.34375v-2.1719h7.4219z"/></g></g></g></g><g transform="translate(152 58)"><g clip-path="url(#ce9f9bb691)"><g><g transform="translate(1.0423 12.478)"><path d="m2.5625-8.9375 2.9219 7.2969 2.9219-7.2969h1.5312v8.9375h-1.1719v-3.4844l0.10938-3.75-2.9375 7.2344h-0.90625l-2.9375-7.2188 0.125 3.7344v3.4844h-1.1875v-8.9375z"/></g><g transform="translate(12.654 12.478)"><path d="m5.9688-2.3281h-3.7344l-0.84375 2.3281h-1.2188l3.4219-8.9375h1.0312l3.4219 8.9375h-1.2188zm-3.3906-0.96875h3.0469l-1.5156-4.1875z"/></g><g transform="translate(21.489 12.478)"><path d="m4.3125-3.625h-2.0938v3.625h-1.1875v-8.9375h2.9531c1.0078 0 1.7852 0.23047 2.3281 0.6875 0.53906 0.46094 0.8125 1.125 0.8125 2 0 0.55469-0.15234 1.0391-0.45312 1.4531-0.29297 0.41797-0.71094 0.72656-1.25 0.92188l2.1094 3.7969v0.078125h-1.2656zm-2.0938-0.95312h1.8125c0.58203 0 1.0469-0.14844 1.3906-0.45312 0.34375-0.30078 0.51562-0.70703 0.51562-1.2188 0-0.55078-0.16797-0.97266-0.5-1.2656-0.32422-0.30078-0.79688-0.45312-1.4219-0.45312h-1.7969z"/></g><g transform="translate(29.864 12.478)"><path d="m7.2188-7.9688h-2.875v7.9688h-1.1719v-7.9688h-2.875v-0.96875h6.9219z"/></g><g transform="translate(37.999 12.478)"><path d="m2.2969 0h-1.1719v-8.9375h1.1719z"/></g><g transform="translate(42.05 12.478)"><path d="m7.9062 0h-1.1875l-4.5-6.8906v6.8906h-1.1875v-8.9375h1.1875l4.5156 6.9219v-6.9219h1.1719z"/></g><g transform="translate(51.647 12.478)"><path d="m5.9688-2.3281h-3.7344l-0.84375 2.3281h-1.2188l3.4219-8.9375h1.0312l3.4219 8.9375h-1.2188zm-3.3906-0.96875h3.0469l-1.5156-4.1875z"/></g><g transform="translate(60.482 12.478)"></g><g transform="translate(64.226 12.478)"><path d="m3.6719-3.9844c-1.0117-0.28906-1.7461-0.64453-2.2031-1.0625-0.46094-0.42578-0.6875-0.95312-0.6875-1.5781 0-0.70703 0.28125-1.2891 0.84375-1.75 0.5625-0.45703 1.2891-0.6875 2.1875-0.6875 0.61328 0 1.1602 0.12109 1.6406 0.35938 0.47656 0.23047 0.84766 0.55859 1.1094 0.98438 0.26953 0.41797 0.40625 0.87109 0.40625 1.3594h-1.1875c0-0.53906-0.17188-0.96094-0.51562-1.2656-0.34375-0.3125-0.82812-0.46875-1.4531-0.46875-0.58594 0-1.0391 0.13281-1.3594 0.39062-0.32422 0.25-0.48438 0.60547-0.48438 1.0625 0 0.36719 0.14844 0.67188 0.45312 0.92188 0.3125 0.25 0.83594 0.48047 1.5781 0.6875 0.75 0.21094 1.332 0.4375 1.75 0.6875 0.41406 0.25 0.72266 0.54688 0.92188 0.89062 0.20703 0.33594 0.3125 0.73047 0.3125 1.1875 0 0.71875-0.28125 1.2969-0.84375 1.7344s-1.3203 0.65625-2.2656 0.65625c-0.61719 0-1.1875-0.11719-1.7188-0.34375-0.53125-0.23828-0.94531-0.5625-1.2344-0.96875-0.29297-0.41406-0.4375-0.88281-0.4375-1.4062h1.1875c0 0.54297 0.19531 0.96875 0.59375 1.2812 0.40625 0.3125 0.94141 0.46875 1.6094 0.46875 0.625 0 1.0977-0.125 1.4219-0.375 0.33203-0.25781 0.5-0.60938 0.5-1.0469s-0.15625-0.77344-0.46875-1.0156c-0.30469-0.23828-0.85547-0.47266-1.6562-0.70312z"/></g><g transform="translate(72.318 12.478)"><path d="m7.6094-2.8438c-0.10547 0.94922-0.45312 1.6836-1.0469 2.2031-0.58594 0.51172-1.3672 0.76562-2.3438 0.76562-1.0547 0-1.8984-0.37891-2.5312-1.1406-0.63672-0.75781-0.95312-1.7695-0.95312-3.0312v-0.85938c0-0.83203 0.14453-1.5625 0.4375-2.1875 0.30078-0.63281 0.72266-1.1172 1.2656-1.4531 0.53906-0.34375 1.1719-0.51562 1.8906-0.51562 0.94531 0 1.707 0.26562 2.2812 0.79688 0.57031 0.53125 0.90625 1.2656 1 2.2031h-1.1719c-0.10547-0.71875-0.32812-1.2344-0.67188-1.5469-0.34375-0.32031-0.82422-0.48438-1.4375-0.48438-0.75 0-1.3398 0.28125-1.7656 0.84375-0.42969 0.55469-0.64062 1.3438-0.64062 2.375v0.85938c0 0.96875 0.19531 1.7422 0.59375 2.3125 0.40625 0.57422 0.97266 0.85938 1.7031 0.85938 0.65625 0 1.1602-0.14453 1.5156-0.4375 0.35156-0.30078 0.58594-0.82031 0.70312-1.5625z"/></g><g transform="translate(81.135 12.478)"><path d="m7.9062 0h-1.1875v-4.1406h-4.5v4.1406h-1.1875v-8.9375h1.1875v3.8438h4.5v-3.8438h1.1875z"/></g><g transform="translate(90.732 12.478)"><path d="m7.9219-4.1875c0 0.875-0.15234 1.6406-0.45312 2.2969-0.29297 0.65625-0.71094 1.1562-1.25 1.5-0.54297 0.34375-1.1719 0.51562-1.8906 0.51562-0.69922 0-1.3242-0.17188-1.875-0.51562-0.54297-0.35156-0.96484-0.84766-1.2656-1.4844-0.30469-0.64453-0.46094-1.3906-0.46875-2.2344v-0.64062c0-0.85156 0.14844-1.6094 0.45312-2.2656 0.30078-0.66406 0.72266-1.1719 1.2656-1.5156 0.55078-0.35156 1.1758-0.53125 1.875-0.53125 0.71875 0 1.3477 0.17188 1.8906 0.51562 0.55078 0.34375 0.97266 0.84375 1.2656 1.5 0.30078 0.65625 0.45312 1.4219 0.45312 2.2969zm-1.1719-0.57812c0-1.0508-0.21484-1.8594-0.64062-2.4219-0.42969-0.57031-1.0273-0.85938-1.7969-0.85938-0.74219 0-1.3242 0.28906-1.75 0.85938-0.42969 0.5625-0.65234 1.3438-0.67188 2.3438v0.65625c0 1.0312 0.21094 1.8438 0.64062 2.4375 0.4375 0.58594 1.0352 0.875 1.7969 0.875 0.75781 0 1.3477-0.27344 1.7656-0.82812 0.41406-0.5625 0.63281-1.3594 0.65625-2.3906z"/></g><g transform="translate(100.01 12.478)"><path d="m2.2188-0.96875h4.25v0.96875h-5.4375v-8.9375h1.1875z"/></g><g transform="translate(107.41 12.478)"><path d="m1.9219-0.96875h5.1094v0.96875h-6.5v-0.89062l4.8906-7.0781h-4.8125v-0.96875h6.2344v0.85938z"/></g></g></g></g><g transform="translate(235 11)"><g clip-path="url(#aaafb43095)"><g><g transform="translate(1.1505 34.725)"><path d="m8.3438-9.8438h-7.4844v-2.75h7.4844z"/></g><g transform="translate(10.365 34.725)"><path d="m6.3125 0h-3.3125v-26.422h3.3125z"/></g><g transform="translate(19.651 34.725)"><path d="m18.281-23.547h-6.9375v23.547h-3.3281v-23.547h-6.9219v-2.875h17.188z"/></g></g></g></g></g></svg>
				</div>';

		return implode('', $html);
	}

	/**
	 * Method to get the field title.
	 *
	 * @return  string  The field title.
	 *
	 * @since   1.0.2
	 */
	protected function getTitle()
	{
		return $this->getLabel();
	}

	/**
	 * Method to get a control group with label and input.
	 *
	 * @param   array  $options  Options to be passed into the rendering of the field
	 *
	 * @return  string  A string containing the html for the control group
	 *
	 * @since   1.0.2
	 */
	public function renderField($options = [])
	{
		$options['class'] = empty($options['class']) ? 'field-sismosinfo' : $options['class'] . ' field-sismosinfo';

		return parent::renderField($options);
	}
}
