<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  System.sismosappointment
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 *
 * @copyright   Copyright (C) 2023 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE
 * @link        https://simplysmart-it.de
 */

namespace SiSmOS\Plugin\System\Sismosappointment\Field;

use Joomla\CMS\Factory;
use Sismos\Library\Field\SismossubformField;

// phpcs:disable PSR1.Files.SideEffects
\defined('JPATH_PLATFORM') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * The Field to load the form inside current form
 *
 * @Example with all attributes:
 *  <field name="field-name" type="subform"
 *      formsource="path/to/form.xml" min="1" max="3" multiple="true" buttons="add,remove,move"
 *      layout="joomla.form.field.subform.repeatable-table" groupByFieldset="false" component="com_example" client="site"
 *      label="Field Label" description="Field Description" />
 *
 * @since  1.0.0
 */
class AppointmentsubformField extends SismossubformField
{
    /**
     * The form field type.
     * @var    string
     */
    protected $type = 'Appointmentsubform';

    /**
     * Form source
     * @var string
     */
    protected $formsource;

    /**
     * Minimum items in repeat mode
     * @var integer
     */
    protected $min = 0;

    /**
     * Maximum items in repeat mode
     * @var integer
     */
    protected $max = 1000;

    /**
     * Layout to render the form
     * @var  string
     */
    protected $layout = 'joomla.form.field.subform.default';

    /**
     * Whether group subform fields by it`s fieldset
     * @var boolean
     */
    protected $groupByFieldset = false;

    /**
     * Which buttons to show in multiple mode
     * @var array $buttons
     */
    protected $buttons = ['add' => true, 'remove' => true, 'move' => true];

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   1.0.0
     */
    protected function getInput()
    {
        /** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();

        $wa->registerAndUseScript('plg_system_sismosappointment', 'plg_system_sismosappointment/sismosappointment.js', [], ['type' => 'module']);

        return parent::getInput();
    }
}
