CREATE TABLE IF NOT EXISTS `#__sismos_appointment_settings` (
	`id` int unsigned NOT NULL AUTO_INCREMENT,
	`contact_id` int unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__contacts table.',
	`regular` text NOT NULL,
	`duration` text NOT NULL,
	`exclude` text NOT NULL,
	`include` text NOT NULL,
	`vcalendar` text NOT NULL,
	`form` text NOT NULL,
	'integration' text NOT NULL,
	`access` int unsigned NOT NULL DEFAULT 0,
	PRIMARY KEY (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_contact` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sismos_appointment_entries` (
	`id` int unsigned NOT NULL AUTO_INCREMENT,
	`contact_id` int unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__contacts table.',
	`name` varchar(255) NOT NULL,
	`email` varchar(255) NOT NULL,
	`message` varchar(5120),
	`appointment` datetime NOT NULL,
	`offset` int NOT NULL DEFAULT 0,
	`duration` int unsigned NOT NULL DEFAULT 60,
	`activation` varchar(100) NOT NULL,
	`block` int NOT NULL DEFAULT 1,
	`created` datetime NOT NULL,
	`meeting_url` varchar(255) NOT NULL DEFAULT '',
	PRIMARY KEY (`id`),
	KEY `idx_contact` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__mail_templates`
--

INSERT INTO `#__mail_templates` (`template_id`, `extension`, `language`, `subject`, `body`, `htmlbody`, `attachments`, `params`) VALUES
('plg_system_sismosappointment.mail_activation', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_ACTIVATION_MAIL_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_ACTIVATION_MAIL_BODY', '', '', '{"tags":["appointment","sitename","name","email","location","body","message","bodyhtml","messagehtml","url","contactname","activate","cancel","cancelHTML"]}'),
('plg_system_sismosappointment.mail_activation_user', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_ACTIVATION_MAIL_USER_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_ACTIVATION_MAIL_USER_BODY', '', '', '{"tags":["appointment","sitename","name","email","location","message","url","contactname"]}'),
('plg_system_sismosappointment.mail', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CONFIRM_MAIL_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CONFIRM_MAIL_BODY', '', '', '{"tags":["appointment","sitename","name","email","location","url","body","message","bodyhtml","messagehtml","contactname","cancel","cancelHTML"]}'),
('plg_system_sismosappointment.mail_user', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CONFIRM_MAIL_USER_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CONFIRM_MAIL_USER_BODY', '', '', '{"tags":["appointment","sitename","name","email","location","message","url","contactname"]}'),
('plg_system_sismosappointment.mail_cancel', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CANCEL_MAIL_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CANCEL_MAIL_BODY', '', '', '{"tags":["appointment","sitename","name","email","url","contactname"]}'),
('plg_system_sismosappointment.mail_cancel_user', 'plg_system_sismosappointment', '', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CANCEL_MAIL_USER_SUBJECT', 'PLG_SYSTEM_SISMOSAPPOINTMENT_CANCEL_MAIL_USER_BODY', '', '', '{"tags":["appointment","sitename","name","email","url","contactname"]}');