// @package   plg_system_sismosappointment  v2.0.2
// @link  https://simplysmart-it.de
// @copyright   (C) 2021 - 2024 Martina Scholz - SimplySmart-IT <https://simplysmart-it.de>. All rights reserved.


"use strict";
if (!window.Joomla) {
  throw new Error("Joomla API was not properly initialised");
}
const sismosappointment = () => {
  let enableInputs = document.querySelectorAll(['input[name="jform[params][sapmt-enabled]"']);
  let inputRegularStart = document.querySelector('input[name="jform[sismosapmt][sapmt-regular][sapmt-regular0][rst]"]');
  let inputRegularEnd = document.querySelector('input[name="jform[sismosapmt][sapmt-regular][sapmt-regular0][ret]"]');
  function setRequired(input, req) {
    input.required = req;
    if (req) {
      input.classList.add("required");
    } else {
      input.classList.remove("required");
    }
  }
  enableInputs.forEach(function(enableSwitch) {
    if (enableSwitch.value == 1 && enableSwitch.checked) {
      setRequired(inputRegularEnd, true);
      setRequired(inputRegularStart, true);
    }
    enableSwitch.addEventListener("change", (event) => {
      if (event.target.value == 0 && event.target.checked) {
        setRequired(inputRegularEnd, false);
        setRequired(inputRegularStart, false);
      }
      if (event.target.value == 1 && event.target.checked) {
        setRequired(inputRegularEnd, true);
        setRequired(inputRegularStart, true);
      }
    });
  });
  document.removeEventListener("DOMContentLoaded", sismosappointment);
};
((document2) => {
  document2.addEventListener("DOMContentLoaded", sismosappointment);
})(document);
