<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Fields.Entries
 *
 * @copyright   Copyright (C) 2023 Martina Scholz. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

\defined('_JEXEC') or die;

/**
 * Layout variables
 * -----------------
 * @var   Form    $tmpl             The Empty form for template
 * @var   array   $forms            Array of JForm instances for render the rows
 * @var   bool    $multiple         The multiple state for the form field
 * @var   int     $min              Count of minimum repeating in multiple mode
 * @var   int     $max              Count of maximum repeating in multiple mode
 * @var   string  $name             Name of the input field.
 * @var   string  $fieldname        The field name
 * @var   string  $fieldId          The field ID
 * @var   string  $control          The forms control
 * @var   string  $label            The field label
 * @var   string  $description      The field description
 * @var   array   $buttons          Array of the buttons that will be rendered
 * @var   bool    $groupByFieldset  Whether group the subform fields by it`s fieldset
 * @var   array   $entries          Entries Array
 */

// $entries = $displayData['value'];
if (empty($displayData['entries'])) {
    return;
}

$entries = $displayData['entries'];
$modalId = "Sismos-appointment-form";

?>
    
<?php foreach ($entries as $entry) : ?>
        <tr>
                <th scope="id"><?php echo $entry['id']; ?></th>
                <td><?php echo $entry['name']; ?></td>
                <td><?php echo $entry['appointment']; ?></td>
                <td><?php echo (string) $entry['offset']; ?></td>
                <td><?php echo $entry['duration']; ?></td>
                <td><?php echo $entry['email']; ?></td>
                <td>
                    <?php echo $entry['message']; ?>
                    <?php echo ($entry['message']) ? '<br><small><i>' . $entry['created'] . '</i></small>' : '<small><i>' . $entry['created'] . '</i></small>';?>
                    <?php echo ($entry['meeting_url']) ? '<br><small>' . Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_MEETINGURL_LABEL') . ':<br>' . HTMLHelper::link($entry['meeting_url'], $entry['meeting_url'], ['target' => '_blank']) . '</small>' : '';?>
                </td>
                <td>
                    <span class="<?php echo ($entry['block'] == '-1') ? 'text-danger icon-times' : (($entry['block']) ? 'text-warning icon-pause' : 'text-success icon-check'); ?> fs-2" aria-hidden="true" aria-describedby="tip-delete-appointment<?php echo $entry["id"]; ?>"></span>
                    <div role="tooltip" id="tip-created-appointment<?php echo $entry['id']; ?>">
                        <?php echo $entry['created']; ?>
                    </div>
                </td>
                <td>
                    <div class="btn-group">
                        <button type="button" data-id="<?php echo $entry['id']; ?>" class="btn btn-success" aria-label="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EDIT_BTN');?>" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EDIT_BTN');?>" type="button" data-sismosappointment="dialog">
                                <span class="icon-edit icon-white" aria-hidden="true"></span> 
                        </button>
                        <button type="button" data-id="<?php echo $entry['id']; ?>" data-task="ics" class="btn btn-primary btnIcsExportApmtEntry" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EXPORTICS_BTN'); ?>" aria-label="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EXPORTICS_BTN'); ?>"><span class="icon-download icon-white" aria-hidden="true"></span> </button>
                        <button type="button" data-id="<?php echo $entry['id']; ?>" data-task="sendMail" class="btn btn-info btnSendMailApmtEntry" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_BTN'); ?>" aria-label="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_BTN'); ?>"><span class="icon-mail" aria-hidden="true"></span> </button>
                        <button type="button" data-id="<?php echo $entry['id']; ?>" data-task="delSingle" class="btn btn-danger btnDeleteApmtEntry" title="<?php echo Text::_('JTOOLBAR_DELETE'); ?>" aria-label="<?php echo Text::_('JTOOLBAR_DELETE'); ?>"><span class="icon-minus icon-white" aria-hidden="true"></span> </button>
                    </div>
                </td>
        </tr>
<?php endforeach; ?>
