<?php

/**
 * @package     Sismosappointments
 * @subpackage  Fields.Entries
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 * @copyright   Copyright (C) 2023 Martina Scholz. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 * @link        https://simplysmart-it.de
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

\defined('_JEXEC') or die;

extract($displayData);

if (empty($displayData['value'])) {
    return;
}

/**
 * Layout variables
 * -----------------
 * @var   Form    $tmpl             The Empty form for template
 * @var   array   $forms            Array of JForm instances for render the rows
 * @var   bool    $multiple         The multiple state for the form field
 * @var   int     $min              Count of minimum repeating in multiple mode
 * @var   int     $max              Count of maximum repeating in multiple mode
 * @var   string  $name             Name of the input field.
 * @var   string  $fieldname        The field name
 * @var   string  $fieldId          The field ID
 * @var   string  $control          The forms control
 * @var   string  $label            The field label
 * @var   string  $description      The field description
 * @var   array   $buttons          Array of the buttons that will be rendered
 * @var   bool    $groupByFieldset  Whether group the subform fields by it`s fieldset
 * @var   Form    $entryEditForm    Form Object for appointment entry edit
 */

$entries = $displayData['value'];
$modalId = "Sismos-appointment-form";

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle('plg_system_sismosappointment.entries', 'plg_system_sismosappointment/sismosappointment_entries.css')
    ->registerAndUseScript('plg_system_sismosappointment.entries', 'plg_system_sismosappointment/sismosappointment_entriesfield.js', [], ['type' => 'module']);

Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_EXPIRED_CONFIRM');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_BLOCKED_CONFIRM');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_ITEM_CONFIRM');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_ITEM_CONFIRM');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_SUCCESS');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UPDATE_SUCCESS');
Text::script('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EDIT_DIALOG_TITLE');
?>

<div class="d-grid d-md-block mb-3">
    <button type="button" id="btnDeleteApmtEntriesExpired" class="btn btn-danger mt-1" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_EXPIRED_CONFIRM');?>"><span class="icon-trash" aria-hidden="true"> </span> <?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_EXPIRED_BTN');?></button>
    <button type="button" id="btnDeleteApmtEntriesO14D" class="btn btn-danger mt-2 mt-md-1 ms-md-2" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_BLOCKED_CONFIRM');?>"><span class="icon-trash" aria-hidden="true"> </span> <?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_BLOCKED_BTN');?></button>
    <button type="button" id="btnExportApmtCSV" class="btn btn-primary mt-2 mt-md-1 ms-md-2" title="<?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EXPORT_CSV_TITLE');?>"><span class="icon-download" aria-hidden="true"> </span> <?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_EXPORT_CSV_BTN');?></button>
</div>

<div class="mt-2">
    <table id="appointment-entries-table" class="table table-striped">
    <thead>
        <tr>
            <th>ID</th>
            <th class="w-1"><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_NAME_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_APPOINTMENT_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_OFFSETGUEST_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_DURATION_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_EMAIL_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_MESSAGE_LABEL'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_STATE_LABEL'); ?></th>
            <th class="w-1"><?php echo Text::_('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_FIELD_ACTIONS_LABEL'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php echo $this->sublayout('items', ['entries' => $entries]); ?>
    </tbody>
    </table>
</div>
<input type="hidden" name="sismosAptmaActionId" value="">

<?php
$formLayout = PluginHelper::getLayoutPath('system', 'sismosappointment', 'appointmentedit_form');
// TODO $formLayout = ModuleHelper::getLayoutPath('mod_sismosappointment', $params->get('layout', 'default') . '_form');
ob_start();
include $formLayout;
$formTemplate = ob_get_clean();
echo $formTemplate;
?>


