(function () {
	'use strict';

	(function () {
		/* SimplySmart-IT - Martina Scholz */
		/* (C) 2023 Martina Scholz, SimplySmart-IT <https://simplysmart-it.de> */


		function sismosappointment_entries() {	

			const btnDeleteO14D = document.getElementById('btnDeleteApmtEntriesO14D');
			const btnDeleteExpired = document.getElementById('btnDeleteApmtEntriesExpired');
			const btnCSVExport = document.getElementById('btnExportApmtCSV');
			const appointmentModal = document.querySelector('[id^="EditAppointmentSismos-appointment-form"]');
			const submitEdit = appointmentModal.querySelector('button[type="submit"]');
			let btnDeleteSingleEntries = document.querySelectorAll('.btnDeleteApmtEntry');
			let btnSendMailEntries = document.querySelectorAll('.btnSendMailApmtEntry');
			let btnIcsExportEntries = document.querySelectorAll('.btnIcsExportApmtEntry');
			

			function DeleteAllEntriesOlder14Days() {
				// alert('Delete 14 Days ContactId: ' + contactId);
				var result = confirm(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_BLOCKED_CONFIRM'));
				if (result) {
					// task is a hidden field in the foot of the form
					let task_id = document.querySelector('input[name="task"]');
					task_id.value = 'O14D';
					sendComand();
				}
			}

			function DeleteAllEntriesExpired() {
				var result = confirm(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_EXPIRED_CONFIRM'));
				if (result) {
					// task is a hidden field in the foot of the form
					let task_id = document.querySelector('input[name="task"]');
					task_id.value = 'EXPIRED';
					sendComand();
				}
			}

			function DeleteSingleEntry(id) {
				var result = confirm(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_DELETE_ITEM_CONFIRM'));
				if (result) {
					let task_id = document.querySelector('input[name="task"]');
					task_id.value = 'delSingle';
					let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
					action_id.value = id;
					sendComand();
				}
			}

			function SendMailEntry(id) {
				var result = confirm(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_ITEM_CONFIRM'));
				if (result) {
					// task is a hidden field in the foot of the form
					let task_id = document.querySelector('input[name="task"]');
					task_id.value = 'sendMail';
					let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
					action_id.value = id;
					sendComand();
				}
			}

			function ExportTableCSV() {			
				// var jsonData = JSON.stringify({contactId:contactId,del:type});
				var xhr = new XMLHttpRequest();
				xhr.open('POST', 'index.php?option=com_ajax&plugin=sismosappointment&group=system&format=raw');
				xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
				xhr.responseType = 'blob';
				xhr.onload = function() {
					if (xhr.status === 200) {
						try {
						const disposition = xhr.getResponseHeader('content-disposition');
						let filename = '';
						let ext = '';
						if (disposition && disposition.indexOf('attachment') !== -1) {
							var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
							var matches = filenameRegex.exec(disposition);
							if (matches != null && matches[1]) { 
								filename = matches[1].replace(/['"]/g, '');
								ext = filename.substr(filename.lastIndexOf('.'));
							}
						}
						let result = xhr.response;
						// Create a link element, hide it, direct it towards the blob, and then 'click' it programatically
						let a = document.createElement("a");
						a.style = "display: none";
						document.body.appendChild(a);
						// Create a DOMString representing the blob and point the link element towards it
						let myurl = window.URL.createObjectURL(result);
						a.href = myurl;
						// use the filename sent by the server to save the file
						a.download = filename;
						// programatically click the link to trigger the download
						a.click();
						// release the reference to the file by revoking the Object URL
						window.URL.revokeObjectURL(myurl);
						// remove the link created for download
						a.remove();
					} catch (err) {
						// XXX
						console.log('Error on load???!!!');
						console.log(err);
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);					
					}
					} else if (xhr.status !== 200) {
						console.log('Request failed.  Returned status of ' + xhr.status);
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);
					}
				};
				let task_id = document.querySelector('input[name="task"]');
				task_id.value = 'CSV';
				const adminform = document.getElementById('contact-form');
				var formData = new FormData(adminform);
				var jsonData = new URLSearchParams(Array.from(formData)).toString();
				
				xhr.send('data=' + jsonData);
				task_id.value = '';
			}

			function ExportIcs(id) {			
				// var jsonData = JSON.stringify({contactId:contactId,del:type});
				var xhr = new XMLHttpRequest();
				xhr.open('POST', 'index.php?option=com_ajax&plugin=sismosappointment&group=system&format=raw');
				xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
				xhr.responseType = 'blob';
				xhr.onload = function() {
					if (xhr.status === 200) {
						try {
						const disposition = xhr.getResponseHeader('content-disposition');
						let filename = '';
						let ext = '';
						if (disposition && disposition.indexOf('attachment') !== -1) {
							var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
							var matches = filenameRegex.exec(disposition);
							if (matches != null && matches[1]) { 
								filename = matches[1].replace(/['"]/g, '');
								ext = filename.substr(filename.lastIndexOf('.'));
							}
						}
						let result = xhr.response;
						// Create a link element, hide it, direct it towards the blob, and then 'click' it programatically
						let a = document.createElement("a");
						a.style = "display: none";
						document.body.appendChild(a);
						// Create a DOMString representing the blob and point the link element towards it
						let myurl = window.URL.createObjectURL(result);
						a.href = myurl;
						// use the filename sent by the server to save the file
						a.download = filename;
						// programatically click the link to trigger the download
						a.click();
						// release the reference to the file by revoking the Object URL
						window.URL.revokeObjectURL(myurl);
						// remove the link created for download
						a.remove();
					} catch (err) {
						// XXX
						console.log('Error on load???!!!');
						console.log(err);
						// console.log(xhr.responseText);	
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);				
					}
					} else if (xhr.status !== 200) {
						console.log('Request failed.  Returned status of ' + xhr.status);
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);
					}
				};

				let task_id = document.querySelector('input[name="task"]');
				task_id.value = 'ics';
				let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
				action_id.value = id;
				const adminform = document.getElementById('contact-form');
				var formData = new FormData(adminform);
				var jsonData = new URLSearchParams(Array.from(formData)).toString();
				
				xhr.send('data=' + jsonData);
				task_id.value = '';
				action_id.value = '';
			}

			function sendComand() {
				var xhr = new XMLHttpRequest();
				xhr.open('POST', 'index.php?option=com_ajax&plugin=sismosappointment&group=system&format=json');
				xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
				xhr.onload = function() {
					let task_id = document.querySelector('input[name="task"]');
					if (xhr.status === 200) {
						try {
						var xhrData = JSON.parse(xhr.responseText);
						if (Boolean(xhrData.success)) {
							switch (task_id.value) {
								case 'sendMail':
									if (xhrData.data[0]['send']) {
										alert(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_SUCCESS'));
										// Joomla.renderMessages({ success: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_SENDMAIL_SUCCESS'))] });
									} else {
										//TODO Error Message
									}
									break;

								case 'loadEntryForm':
									var entrydata = xhrData.data[0]['entryData'];
									let formContainer = document.querySelector('#appointmentEditForm');
									Object.keys(entrydata).forEach(key=>{
										var input= formContainer.querySelector('[name="' + key + '"]');
										if (input) {
											switch (input.nodeName)
											{
												case 'INPUT':
													input.value = entrydata[key];
													break;
												case 'SELECT':
													input.value = entrydata[key];
													break;
												case 'TEXTAREA':
													input.textContent = entrydata[key];
													break;
												default:
													// console.log(input.nodeName);
											}									
											// console.log(input.name + ': ' + input.value);
										}
									});
									break;
								default:
									if (xhrData.data[0]['reload']) {
										var table = document.querySelector('table#appointment-entries-table');
										var tbody = table.querySelector('tbody');
										tbody.innerHTML = xhrData.data[0]['FieldEntries'];
										btnDeleteSingleEntries = tbody.querySelectorAll('.btnDeleteApmtEntry');
										btnDeleteSingleEntries.forEach(function (btnDeleteSingleEntry) {
										btnDeleteSingleEntry.addEventListener('click', function(){ DeleteSingleEntry(btnDeleteSingleEntry.dataset.id);});
										});
										btnSendMailEntries = document.querySelectorAll('.btnSendMailApmtEntry');
										btnSendMailEntries.forEach(function (btnSendMailEntry) {
											btnSendMailEntry.addEventListener('click', function(){ SendMailEntry(btnSendMailEntry.dataset.id);});
										});
										btnIcsExportEntries = document.querySelectorAll('.btnIcsExportApmtEntry');
										btnIcsExportEntries.forEach(function (btnIcsExport) {
											btnIcsExport.addEventListener('click', function(){ ExportIcs(btnIcsExport.dataset.id);});
										});
										if (task_id.value === 'submitEntryForm') {
											var modal = bootstrap.Modal.getInstance(appointmentModal);
											modal.hide();
											let success = {
												success: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UPDATE_SUCCESS'))]
											};
											Joomla.renderMessages(success);
										}
									} else {
										//TODO Error Message
									}
							}
						} else {
							let error = {
								error: [(Joomla.Text._(xhrData.message))]
							};
							Joomla.renderMessages(error);
						}
						// alert('DEL: ' + xhrData.data[0]['DelType'] + ' ContactId: ' + xhrData.data[0]['ContactId'] + ' Deleted: ' + xhrData.data[0]['deleted']);
						//form.style.display = 'block';		
						
					} catch (err) {
						console.log('Error on load???!!!');
						console.log(err);
						// console.log(xhr.responseText);
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);				
					}
					} else if (xhr.status !== 200) {
						console.log('Request failed.  Returned status of ' + xhr.status);
						let error = {
							error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
						};
						Joomla.renderMessages(error);
					}
					task_id.value = '';
					let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
					action_id.value = '';
				};
				const adminform = document.getElementById('contact-form');
				var formData = new FormData(adminform);
				var jsonData = new URLSearchParams(Array.from(formData)).toString();
				xhr.send('data=' + jsonData);
			}

			btnCSVExport.addEventListener('click', ExportTableCSV);
			btnDeleteO14D.addEventListener('click', DeleteAllEntriesOlder14Days);
			btnDeleteExpired.addEventListener('click', DeleteAllEntriesExpired);
			btnDeleteSingleEntries.forEach(function (btnDeleteSingleEntry) {
				btnDeleteSingleEntry.addEventListener('click', function(){ DeleteSingleEntry(btnDeleteSingleEntry.dataset.id);});
			});
			btnSendMailEntries.forEach(function (btnSendMailEntry) {
				btnSendMailEntry.addEventListener('click', function(){ SendMailEntry(btnSendMailEntry.dataset.id);});
			});
			btnIcsExportEntries.forEach(function (btnIcsExport) {
				btnIcsExport.addEventListener('click', function(){ ExportIcs(btnIcsExport.dataset.id);});
			});
			appointmentModal.addEventListener('show.bs.modal', function (event) {
				let modalBody = event.target.querySelector('.modal-body');
				let id = event.relatedTarget.dataset.id;
				let task_id = document.querySelector('input[name="task"]');
				task_id.value = 'loadEntryForm';
				let action_id = document.querySelector('input[name="sismosAptmaActionId"]');
				action_id.value = id;
				let template = modalBody.querySelector('#appointmentEditTemplate');
				if (!template) {
					let error = {
						error: [(Joomla.Text._('PLG_SYSTEM_SISMOSAPPOINTMENT_ENTRIES_TABLE_UNDEFINED_ERROR'))]
					};
					Joomla.renderMessages(error);
					event.preventDefault();
				} else {
					var newFields = template.content.firstElementChild.cloneNode(true);
					newFields.id = 'appointmentEditForm';
					modalBody.appendChild(newFields);
					sendComand();
				}
				
			});
			appointmentModal.addEventListener('hidden.bs.modal', function (event) {
				let modalBody = event.target.querySelector('.modal-body');
				var editFields = modalBody.querySelector('#appointmentEditForm');
				if (editFields) {
					modalBody.removeChild(editFields);
				}
			});

			submitEdit.addEventListener('click', event =>{
				event.preventDefault();
				let task_id = document.querySelector('input[name="task"]');
				task_id.value = 'submitEntryForm';
				sendComand();
			});
		}

		document.addEventListener("DOMContentLoaded", sismosappointment_entries);

	})();

})();
//# sourceMappingURL=sismosappointment_entriesfield.js.map
