<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Fields.Entries
 *
 * @author      Martina Scholz <martina@simplysmart-it.de>
 * @copyright   Copyright (C) 2023 Martina Scholz. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 * @link        https://simplysmart-it.de
 */

defined('_JEXEC') or die;

/**
 * Layout variables
 * -----------------
 * @var   Form    $form             The Empty form for template
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$form =  $displayData['entryEditForm'];
$appointmentFieldset = $form->getFieldset('appointment');
?>
<template id="appointmentEditTemplate">
<div class="mod-sismosappointment__form appointment-form px-4 pb-3 pt-2">
	<?php // if (array_key_exists('appointment', $fieldsets)) : ?>
	<fieldset class="m-0">    
		<?php if (isset($appointmentFieldset->label) && ($legend = trim(Text::_($appointmentFieldset->label))) !== '') : ?>
			<legend><?php echo $legend; ?></legend>
		<?php endif; ?> 
		<div class="row">
			<div class="col-md-5">
				<?php echo $form->getField('appointment_datetime')->renderField(); ?>
			</div>
			<div class="col-md-4">
				<?php echo $form->getField('appointment_duration')->renderField(); ?>
			</div>
			<div class="col-md-3">
				<?php echo $form->getField('appointment_id')->renderField(); ?>
			</div>
		</div>
		
		
		
	</fieldset>
	<?php // endif; ?>
	<fieldset class="m-0 row">
	<div class="col-md-6">
		<?php echo $form->getField('appointment_name')->renderField(); ?>
		<?php echo $form->getField('appointment_email')->renderField(); ?>
	</div>
	<div class="col-md-6">
		<?php echo $form->getField('appointment_message')->renderField(); ?>
	</div>
	<div class="col-12">
		<?php echo $form->getField('appointment_meeting_url')->renderField(); ?>
	</div>
	</fieldset>
</div>
</template>
