<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Fields.Appointmentsubform
 *
 * @copyright   (C) 2023 Martina Scholz, SimplySmart-IT <https://simplysmart-it.de>
 * @license     GNU General Public License version 3 or later; see LICENSE.txt

 * @phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace
 */

 namespace Joomla\Plugin\System\Sismosappointment\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('JPATH_PLATFORM') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Form Field class for the Joomla Platform.
 * Supports a generic list of options.
 *
 * @since  1.7.0
 */
class ConferenceintegrationField extends ListField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.7.0
	 */
	protected $type = 'Conferenceintegration';

	/* /**
	 * Name of the layout being used to render the field
	 *
	 * @var    string
	 * @since  4.0.0
	 */
	// protected $layout = 'joomla.form.field.radio.switcher';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   3.7.0
	 */
	protected function getOptions()
	{
		$options = parent::getOptions();

		foreach ($options as $index => &$option) {
			if ($option->value && (string) $option->value !== "-1" && !PluginHelper::isEnabled('sismosappointment', $option->value)) {
				$option->disable = true;
				$option->text = Text::sprintf('PLG_SYSTEM_SISMOSAPPOINTMENT_FIELD_VIDEOCONFERENCE_TOOL_OPTION_DISABLED', $option->text);
			}
		}

		return $options;
	}
}
