(function () {
	'use strict';

	(function () {
		/* SimplySmart-IT - Martina Scholz */
		/* (C) 2023 Martina Scholz, SimplySmart-IT <https://simplysmart-it.de> */

		function sismosappointment() {

			let enableInputs = document.querySelectorAll(['input[name="jform[params][sapmt-enabled]"']);
			let inputRegularStart = document.querySelector('input[name="jform[sismosapmt][sapmt-regular][sapmt-regular0][rst]"]');
			let inputRegularEnd = document.querySelector('input[name="jform[sismosapmt][sapmt-regular][sapmt-regular0][ret]"]');

			function setRequired(input, req) {
				input.required = req;

				if (req) {				
					input.classList.add('required');
				} else {
					input.classList.remove('required');
				}
			}

			enableInputs.forEach(function (enableSwitch) {

				if (enableSwitch.value == 1 && enableSwitch.checked) {
					setRequired(inputRegularEnd,true);
					setRequired(inputRegularStart,true);
				}

				enableSwitch.addEventListener('change', event =>{
					if (event.target.value == 0 && event.target.checked) {
						setRequired(inputRegularEnd,false);
						setRequired(inputRegularStart,false);
					}

					if (event.target.value == 1 && event.target.checked) {
						setRequired(inputRegularEnd,true);
						setRequired(inputRegularStart,true);
					}
					
				});
			});

			document.removeEventListener("DOMContentLoaded", sismosappointment);	
		}
		document.addEventListener("DOMContentLoaded", sismosappointment);

	})();

})();
//# sourceMappingURL=sismosappointment.js.map
