<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_sismosappointment
 *
 * @copyright   Copyright (C) 2023 Martina Scholz. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Module\Menu\Site\Helper\MenuHelper;

HTMLHelper::_('behavior.keepalive');
$modalId = "Sismos-appointment-form";
$btnText = ($params->get('modal_button', '')) ?: Text::_('MOD_SISMOSAPPOINTMENT_BOOKING_MODAL_BUTTON_DEFAULT');
$modalSupport = ($uikitModal) ? 'uk-toggle="target: #ModalOpen' . $modalId . '"' : 'data-bs-toggle="modal" data-bs-target="#ModalOpen' . $modalId . '"';

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$html = '<div id="AppointmentMsg"></div><div style="text-align:center"><p style="font-size:2.5rem">' . Text::_('MOD_APPOINTMENT_LOAD_ERR_MESSAGE') . '</p><button type="button" class="btn btn-secondary" onClick="window.location.reload()"><span class="icon-loop" aria-hidden="true"></span> ' . Text::_('MOD_APPOINTMENT_RELOAD_ACTION') . '</button></div>';
// Enable assets
$wa->registerAndUseStyle('mod_sismosappointment.modal', 'mod_sismosappointment/sismosappointment_modal.css')//; //TODO Media CSS
	->registerAndUseStyle('mod_sismosappointment.booking', 'mod_sismosappointment/sismosappointment.css')
	->useStyle('fontawesome')
	->useScript('bootstrap.modal')
	->useScript('bootstrap.tab')
	->useScript('short-and-sweet')
	->registerAndUseScript('mod_sismosappointment.booking', 'mod_sismosappointment/sismosappointment.js')
	->addInlineStyle($cssVars);
	
	Text::script('MOD_APPOINTMENT_RELOAD_ACTION');
	Text::script('MOD_APPOINTMENT_LOAD_ERR_MESSAGE');
	Text::script('MOD_APPOINTMENT_REQUEST_SUCCESS');
	Text::script('JLIB_FORM_CONTAINS_INVALID_FIELDS');
	Text::script('MOD_APPOINTMENT_SAVE_ERR_MESSAGE');
	Text::script('MOD_APPOINTMENT_MAIL_ERR_MESSAGE');
	Text::script('MOD_SISMOSAPPOINTMENT_BOOKING_DEFAULT_LABEL');
// }
?>

<div class="mod_sismosappointment<?php echo $moduleclass_sfx ?? ''; ?>">

<?php if ($content) : ?>
<div class="mod_sismosappointment__content">
	<?php echo $content ?? ''; ?>
</div>
<?php endif; ?>

<button class="btn btn-primary" type="button" 
	<?php echo $modalSupport; ?> data-contact="<?php echo $contactId;?>" data-mod="<?php echo $module->id;?>:<?php echo MenuHelper::getActive($params)->id;?>">
	<span class="icon-calendar" aria-hidden="true"></span> <?php echo Text::_($btnText) ?>
</button>

</div>
