(function () {
	'use strict';

	(function () {

		(function () {
			/* SimplySmart-IT - Martina Scholz */
			/* (C) 2023 Martina Scholz, SimplySmart-IT <https://simplysmart-it.de> */

			function ErrorHandling(parent) {
				const reloadMsg = Joomla.JText._('MOD_APPOINTMENT_RELOAD_ACTION');
				const loadErrMsg = Joomla.JText._('MOD_APPOINTMENT_LOAD_ERR_MESSAGE');
				var errorNode = document.querySelector('.appointmentErrContainer');
				if (!errorNode) {
					errorNode = document.createElement('div');
					errorNode.classList.add('appointmentErrContainer');
					errorNode.style.textAlign = 'center';
					parent.appendChild(errorNode);
				}
				errorNode.innerHTML ='<p>' + loadErrMsg + '</p><button type="button" class="btn btn-secondary" id="errReloadPageApmt"><span class="icon-loop" aria-hidden="true"></span> ' + reloadMsg +'</button>';
				let btnReload = errorNode.querySelector('#errReloadPageApmt');
				btnReload.addEventListener("click", event => {
					window.location.reload();
				});
			}

			function sismosappointment() {

				const appointmentModals = document.querySelectorAll('[id^="ModalOpenSismos-appointment-form"]');

				var toggleButtons = document.querySelectorAll('[uk-toggle="target: #ModalOpenSismos-appointment-form"]');
				var relatedTarget;

				if (typeof UIkit !== "undefined" && toggleButtons) {
					toggleButtons.forEach(function (toggle) {
						toggle.addEventListener('click', function (event) {
							relatedTarget = event.target;
							//UIkit.modal('#ModalOpenSismos-appointment-form', {'bgClose':false}).show();
							var uikitModal = UIkit.modal('#ModalOpenSismos-appointment-form');//.show();
							uikitModal.show();
						});
					});
				}
				
				function openModal(event) {
					let modal = event.target;
					let modalBody = modal.querySelector('[class$="modal-body"]');
					let modalTitle = modal.querySelector('[class$="modal-title"]');
					modalBody.innerHTML = "";
					if (modalTitle) {
						modalTitle.hidden = true;
					}
					var xhr = new XMLHttpRequest();
					xhr.open('POST', 'index.php?option=com_ajax&module=sismosappointment&method=getAppointmentForm&format=json');
					xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
					var utcoffset = new Date().getTimezoneOffset(); // TODO dynamic by user selection date ???
					if (event.relatedTarget) {
						relatedTarget = event.relatedTarget;
					}
					let contactId = relatedTarget.dataset.contact;
					let moduleId = relatedTarget.dataset.mod;
					let formData = new FormData();
					formData.append('getSismosappointmentFormAjax', 1);
					formData.append('jform[tzoffset]', utcoffset);
					formData.append('jform[moduleId]', moduleId);
					formData.append('jform[contactId]', contactId);
					var jsonData = new URLSearchParams(Array.from(formData)).toString(); //JSON.stringify(obj);
					xhr.onload = function() {
						if (xhr.status === 200) {
							try {
								var xhrData = JSON.parse(xhr.responseText);
								var head= document.getElementsByTagName('head')[0];
								// Header
								if (xhrData.data.modalTitle) {
									modalTitle = modal.querySelector('[class$="modal-title"]');
									if (modalTitle) {
										modalTitle.textContent = xhrData.data.modalTitle;
										modalTitle.hidden = false;
									}
								}
								//Captcha
								if (xhrData.data.scripts) {

									Object.keys(xhrData.data.scripts).forEach(key => {
										// TODO Attributes console.log(key ,xhrData.data.scripts[key][0], xhrData.data.scripts[key][1]);
										var script = head.querySelector('script[data-asset-name="' + key + '"]');
										var newscript= document.createElement('script');
										newscript.src= xhrData.data.scripts[key][0];
										newscript.setAttribute('data-asset-name',key);
										if (script) {script.remove();}
										head.appendChild(newscript);
									});
								} 
								if (xhrData.data.styles) {
									Object.keys(xhrData.data.styles).forEach(key=>{
										// TODO Attributes console.log(key ,xhrData.data.styles[key][0], xhrData.data.styles[key][1]);
										var stylesheet = head.querySelector('link[data-asset-name="' + key + '"]');
										if (!stylesheet) {
											stylesheet= document.createElement('link');
											stylesheet.setAttribute('data-asset-name',key);
											stylesheet.href = xhrData.data.scripts[key][0];
											stylesheet.rel = 'stylesheet';
											head.appendChild(stylesheet);
										}
									});
								} 
							} catch (err) {
								console.log('Error on load???!!!');
								console.log(err);
								ErrorHandling(modalBody);
							}
							
							modalBody.innerHTML = xhrData.data['form'];
							/* var form = modalBody.querySelector('form');
							if (!form) {
								var input = modalBody.querySelector('input');
								form = input.form;//modalBody.querySelector('div#appointment-form-container');
							} */
							// sismosappointment_loadedForm(form);
							sismosappointment_loadedForm(modal);
							Joomla.removeMessages('#AppointmentMsg');
						}
						else if (xhr.status !== 200) {
							console.log('Request failed.  Returned status of ' + xhr.status);
							ErrorHandling(modalBody);
						}
						if (modalTitle) {
							modalTitle.hidden = false;
						}
					};
					xhr.send('data=' + jsonData);
				}
				function closeModal(event) {
					relatedTarget = false;
					let modalBody = event.target.querySelector('[class$="modal-body"]');
					modalBody.innerHTML = '';
					let modalTitle = event.target.querySelector('[class$="modal-title"]');
					modalTitle.textContent = Joomla.JText._('MOD_SISMOSAPPOINTMENT_BOOKING_DEFAULT_LABEL');
					ErrorHandling(modalBody);
				}

				appointmentModals.forEach(function (el) {
					el.addEventListener('show.bs.modal', function (event) {
						openModal(event);
					});

					el.addEventListener('hidden.bs.modal', function (event) {
						closeModal(event);
					});

					if (typeof UIkit !== "undefined") {
						var modalShown = false;
						el.setAttribute('uk-modal','bg-close: false');
						UIkit.util.on('#' + el.id, 'beforeshow', function (event) {	
							if (!relatedTarget) {
								event.preventDefault();
							}
						});
		
						UIkit.util.on('#' + el.id, 'show', function (event) {
							openModal(event);
						});

						UIkit.util.on('#' + el.id, 'shown', function (event) {
							modalShown = true;
						});

						UIkit.util.on('#' + el.id, 'beforehide', function (event) {
							if (!modalShown) {
								event.preventDefault();
							}
						});
		
						UIkit.util.on('#' + el.id, 'hidden', function (event) {
							closeModal(event);
							modalShown = false;
						});
					}
				});			
			}

			function sismosappointment_loadedForm(modal) {
				let form = modal.querySelector('form');
				if (!form) {
					var input = modal.querySelector('input');
					form = input.form;
				}
				let ele = document.getElementById('booking-tab');
				let next = document.getElementById('booking-next');
				let prev = document.getElementById('booking-prev');
				let activeAppointmentDate = ele.querySelector('button.booking-tab-slider__anchor.active');
				let activeDatePos = activeAppointmentDate.getBoundingClientRect().left - ele.getBoundingClientRect().left;
				const formContainer = modal.querySelector('#appointment-form-container');
				let tabEl = formContainer.querySelectorAll('button[data-bs-toggle="tab"]');
				const inputs = formContainer.querySelectorAll('input');


				if (activeDatePos > 120) {
					ele.scrollLeft = ele.scrollLeft + (activeDatePos - 120);
				}

				let pos = { top: 0, left: 0, x: 0, y: 0 };

				const mouseDownHandler = function (e) {
					// Change the cursor and prevent user from selecting the text
					ele.style.cursor = 'grabbing';
					ele.style.userSelect = 'none';
					pos = {
						// The current scroll
						left: ele.scrollLeft,
						// Get the current mouse position
						x: e.clientX,
					};

					document.addEventListener('mousemove', mouseMoveHandler);
					document.addEventListener('mouseup', mouseUpHandler);
				};

				const mouseMoveHandler = function (e) {
					// How far the mouse has been moved
					const dx = e.clientX - pos.x;

					// Scroll the element
					ele.scrollLeft = pos.left - dx;
				};

				const mouseUpHandler = function () {
					document.removeEventListener('mousemove', mouseMoveHandler);
					document.removeEventListener('mouseup', mouseUpHandler);

					ele.style.cursor = 'grab';
					ele.style.removeProperty('user-select');
				};

				const moveNext = function () {
					ele.scrollLeft = ele.scrollLeft + 110;
				};

				const movePrev = function () {
					ele.scrollLeft = ele.scrollLeft - 110;
				};

				// Attach the `mousedown` event handler
				ele.addEventListener('mousedown', mouseDownHandler);
				next.addEventListener('click', moveNext);
				prev.addEventListener('click', movePrev);	

				// Form Submit
				function submitForm() {
					var formData = new FormData(form);
					formData.append('jform[tzoffset]', new Date().getTimezoneOffset()); // TODO Timezoneoffset by selected Date
					var jsonData = 'submitSismosappointmentFormAjax=1&' + new URLSearchParams(Array.from(formData)).toString();//JSON.stringify(formObj);
					var xhr = new XMLHttpRequest();			

					xhr.open('POST', 'index.php?option=com_ajax&module=sismosappointment&method=submitForm&format=json');
					xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
					xhr.onload = function() {
						if (xhr.status === 200) {
							try {						
								var xhrData = JSON.parse(xhr.responseText);	
							} catch (err) {
								console.log('Error on load???!!!');
								console.log(err);
								formContainer.style.display = 'none';
								let modalBody = document.querySelector('.modal-body');
								ErrorHandling(modalBody);
							}							
							if (Boolean(xhrData.success)) {
								Joomla.removeMessages('#sismos-appointmentform-alert');	
								formContainer.style.display = 'none';
								let success = {
									success: [(Joomla.Text._('MOD_APPOINTMENT_REQUEST_SUCCESS'))]
								};
								Joomla.renderMessages(success, '#AppointmentMsg',false);
								if (!xhrData.data['mail']) {
									let error = {
										error: [(Joomla.Text._('MOD_APPOINTMENT_MAIL_ERR_MESSAGE'))]
									};
									Joomla.renderMessages(error, '#AppointmentMsg',false);
								}
							} else {
								let error = {
									error: [(Joomla.Text._(xhrData.message))]
								};
								Joomla.renderMessages(error, '#sismos-appointmentform-alert');
								if (xhrData.data['field']) {
									var field = formContainer.querySelector('.form_appointment_datetime_field');
									field.outerHTML = xhrData.data['field'];
									sismosappointment_loadedForm(modal);
								} else {
									let messageContainer = document.querySelector('#sismos-appointmentform-alert');
									ErrorHandling(messageContainer);
								}
							}
						}
						else if (xhr.status !== 200) {
							console.log('Request failed.  Returned status of ' + xhr.status);
							// console.log('Error ' + xhr.responseText);
							let modalBody = modal.querySelector('.modal-body');
							ErrorHandling(modalBody);
						}
					};
					xhr.send('data=' + jsonData);
				}

				// Validation
				function validate(el) {
					let result = true;
					const label = el.form.querySelector(`label[for="${el.id}"]`);
					if (el.validity.valid && checkNumber(el)) {
						if (el.classList.contains('invalid')) {
							el.classList.add('valid');
						}
						el.classList.remove('invalid');
						if (label) {
							label.classList.remove('invalid');
						}
						if (el.type == 'radio' && el.name == 'appointment_datetime') {
							el.form.querySelector(`label[for="${el.name}"]`).classList.remove('invalid');
						}
					} else {
						el.classList.remove('valid');
						el.classList.add('invalid');
						label.classList.add('invalid');
						if (el.type == 'radio' && el.name == 'appointment_datetime') {
							el.form.querySelector(`label[for="${el.name}"]`).classList.add('invalid');
						}
						if (el.type !== 'tel') {
							el.addEventListener("input", event => {
								validate(el);
							});
						}
						result = false;
					}
					return result;
				}

				function checkNumber(el) { 
					if (el.type === 'tel') {
						var regEx = /^\+{0,2}([\-\. ])?(\(?\d{0,4}\))?([\/\-\. ])?\(?\d{0,4}\)?([\/\-\. ])?\d{3}([\/\-\. ])?\d{4}/;
						if(el.value && !el.value.match(regEx))
							{
								return false;
							}				
					}
					return true;
				}

				function formValidation() {
					let result = true;
					form.querySelectorAll('input').forEach(function (el) { 
						if (el.type == 'radio' && el.disabled == true) {
							return;
						}
						if (!validate(el) || !checkNumber(el)) {
							result = false;
						}			}); 
					if (!result) {
						let message;
						let error;
						if (form.getAttribute('data-validation-text')) {
							message = form.getAttribute('data-validation-text');
						} else {
							message = Joomla.Text._('JLIB_FORM_CONTAINS_INVALID_FIELDS');
						}
					
						error = {
							error: [message]
						};
						Joomla.renderMessages(error, '#sismos-appointmentform-alert');
					}
					return result;
				}

				function isValid(e) {
					var btnSumbit = e.target; //.querySelector('button[type="submit"]');
					if (btnSumbit.hasAttribute('disabled')) {
						return false
					} else {
						return true;
					}
				} 

				function reload_js()
				{
					var head= document.getElementsByTagName('head')[0];
					var script = head.querySelector('script[data-asset-name="short-and-sweet"]');
					if (script) {
						var newscript= document.createElement('script');
						newscript.src= script.src;
						newscript.defer = script.defer;
						script.remove();
						head.appendChild(newscript);
					}
				}

				// form.querySelector('button[type="submit"]').addEventListener("click", formValidation);

				modal.querySelector('button[type="submit"]').addEventListener("click", function (e) {
					e.preventDefault();    //stop form from submitting
					if(isValid(e) && formValidation()){
						submitForm();
					} 
				});

				tabEl.forEach(function (elTab) {
					elTab.addEventListener('shown.bs.tab', function(ev){
						var targetId = ev.target.getAttribute('data-bs-target');
						form.querySelector(targetId).querySelectorAll('input[type="radio"]').forEach(function (inputEl) { 
							inputEl.required = true;
							inputEl.disabled = false;
						});
						var relatedtargetId = ev.relatedTarget.getAttribute('data-bs-target');
						form.querySelector(relatedtargetId).querySelectorAll('input[type="radio"]').forEach(function (inputEl) { 
							inputEl.required = false;
							inputEl.disabled = true; // prevent Javascript error control is not focusable on validation in chrome browsers
							inputEl.checked = false;
						}); 
					});	
				});	

				reload_js();

				inputs.forEach(function (el) { 
					el.addEventListener("blur", event => {
						validate(el);
					});
				});
			}

			document.addEventListener("DOMContentLoaded", sismosappointment);

		})();

	})();

})();
//# sourceMappingURL=sismosappointment.js.map
