<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_sismosappointment
 *
 * @author     Martina Scholz <martina@simplysmart-it.de>
 * @copyright  Martina Scholz - SimplySmart-IT
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://simplysmart-it.de
 */

namespace Joomla\Module\Sismosappointment\Site\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\Database\ParameterType;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Methods supporting a list of article records.
 *
 * @since  1.6
 */
class AppointmentsModel extends ListModel
{
	/**
	 * Constructor.
	 *
	 * @param   array  $config  An optional associative array of configuration settings.
	 *
	 * @since   1.6
	 * @see     \Joomla\CMS\MVC\Controller\BaseController
	 */
	public function __construct($config = [])
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = [
				'id', 'a.id',
				'name', 'a.name',
				'email', 'a.email',
				'message', 'a.message',
				'appointment', 'a.appointment',
				'duration', 'a.duration',
				'block', 'a.block',
				// TODO 'modified', 'a.modified',
				// TODO 'modified_by', 'a.modified_by',
				'meeting_url', 'a.meeting_url',
				// TODO 'ordering', 'a.ordering',
			];
		}

		parent::__construct($config);
	}

	/**
	 * Get the filter form
	 *
	 * @param   array    $data      data
	 * @param   boolean  $loadData  load current data
	 *
	 * @return  \Joomla\CMS\Form\Form|null  The Form object or null if the form can't be found
	 *
	 * @since   3.2
	 */
	/* TODO Field Appointments public function getFilterForm($data = [], $loadData = true)
	{
		$form = parent::getFilterForm($data, $loadData);

		$ordering = $form->getField('fullordering', 'list');

		$ordering->addOption('JSTAGE_ASC', ['value' => 'ws.title ASC']);
		$ordering->addOption('JSTAGE_DESC', ['value' => 'ws.title DESC']);

		return $form;
	} */

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  \Joomla\Database\DatabaseQuery
	 *
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDatabase();
		$query = $db->getQuery(true);
		$user  = Factory::getUser();

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				[
					$db->quoteName('a.id'),
					$db->quoteName('a.contact_id'),
					$db->quoteName('a.name'),
					$db->quoteName('a.email'),
					$db->quoteName('a.message'),
					$db->quoteName('a.appointment'),
					$db->quoteName('a.offset'),
					$db->quoteName('a.duration'),
					$db->quoteName('a.activation'),
					$db->quoteName('a.block'),
					$db->quoteName('a.created'),
					// $db->quoteName('a.modified_by'),
					// $db->quoteName('a.modified'),
					// TODO $db->quoteName('a.ordering'),
					$db->quoteName('a.meeting_url'),
				]
			)
		)
			->from($db->quoteName('#__sismos_appointment_entries', 'a'));

		// Filter by access level.
		// TODO $access = $this->getState('filter.access');

		// if (is_numeric($access)) {
			// $access = (int) $access;
			// $query->where($db->quoteName('a.access') . ' = :access')
				// ->bind(':access', $access, ParameterType::INTEGER);
		// } elseif (is_array($access)) {
			// $access = ArrayHelper::toInteger($access);
			// $query->whereIn($db->quoteName('a.access'), $access);
		// }

		// Filter by contact_id
		$contactId = $this->getState('filter.contact_id');

		if (is_numeric($contactId)) {
			$contactId = (int) $contactId;
			$query->where($db->quoteName('a.contact_id') . '= :contactId')
				->bind(':contactId', $contactId, ParameterType::INTEGER);
		}

		$block = $this->getState('filter.block');

		if ($block) {
			$query->where($db->quoteName('a.block') . '> -1');
		}

		// Filter by dateRange
		$current = $this->getState('filter.current');

		if ($current) {
			$date = Factory::getDate('00:00:00', 'UTC')->toSql();
			$query->where('DATE(' . $db->quoteName('a.appointment') . ') >= :date')
				->bind(':date', $date, ParameterType::STRING);
		}

		// Filter by search in title.
		$search = $this->getState('filter.search');

		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$search = (int) substr($search, 3);
				$query->where($db->quoteName('a.id') . ' = :search')
					->bind(':search', $search, ParameterType::INTEGER);
			} elseif (stripos($search, 'name:') === 0) {
				$search = '%' . substr($search, 7) . '%';
				$query->where($db->quoteName('a.name') . ' LIKE :search')
					->bind(':search', $search, ParameterType::STRING);
			} elseif (stripos($search, 'message:') === 0) {
				$search = '%' . substr($search, 8) . '%';
				$query->where($db->quoteName('a.message') . ' LIKE :search')
					->bind(':search', $search, ParameterType::STRING);
			} else {
				$search = '%' . str_replace(' ', '%', trim($search)) . '%';
				$query->where(
					'(' . $db->quoteName('a.email') . ' LIKE :search1 OR ' . $db->quoteName('a.meeting_url') . ' LIKE :search2)'
				)
					->bind([':search1', ':search2'], $search);
			}
		}

		// TODO Add the list ordering clause.
		// $orderCol  = $this->state->get('list.ordering', 'a.id');
		// $orderDirn = $this->state->get('list.direction', 'DESC');

		// if ($orderCol === 'a.ordering' || $orderCol === 'category_title') {
			// $ordering = [
				// $db->quoteName('c.title') . ' ' . $db->escape($orderDirn),
				// $db->quoteName('a.ordering') . ' ' . $db->escape($orderDirn),
			// ];
		// } else {
			// $ordering = $db->escape($orderCol) . ' ' . $db->escape($orderDirn);
		// }

		// $query->order($ordering);

		return $query;
	}

	/**
	 * Method to get a list of articles.
	 * Overridden to add item type alias.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 *
	 * @since 1.0.5
	 */
	public function getItems()
	{
		$items = parent::getItems();

		return $items;
	}
}
