<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Fields.Appointment
 *
 * @copyright   (C) 2022 Martina Scholz, SimplySmart-IT <https://simplysmart-it.de>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Date\Date;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * // TODO Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern (Reg Ex) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellcheck      Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   array    $options         Options available for this field.
 * @var   string   $dataAttribute   Miscellaneous data attributes preprocessed for HTML output
 * @var   array    $dataAttributes  Miscellaneous data attribute for eg, data-*.
 * @var   string   $utcInfo         utcInfo
 * @var   string   $durationInfo    durationInfo.
 */

/**
 * The format of the input tag to be filled in using sprintf.
 *     %1 - id
 *     %2 - name
 *     %3 - value
 *     %4 = any other attributes
 */
$format = '<input type="radio" id="%1$s" name="%2$s" group="%5$s" value="%3$s" %4$s>';
$alt    = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $name);
$isActive = ' active';

$language = Factory::getApplication()->getLanguage();
$language->load('mod_sismosappointment', JPATH_BASE . '/modules/mod_sismosappointment');
?>

<?php if (!empty($options)) : ?>
	<div class="booking-tab-slider">
		<button id="booking-prev" class="booking-tab-slider__prev" type="button" role="button">
			<span class="icon-chevron-left" aria-hidden="true"></span>
		</button>
	<ul class="appointment booking-tab-slider__list nav nav-pills" id="booking-tab" role="tablist">
		<?php $curGroup = ''; ?>
		<?php foreach ($options as $i => $option) : ?>
			<?php if ($curGroup === $option->group) {
				continue;
			}; ?>
			<?php $curGroup = $option->group; ?>
			<li class="booking-tab-slider__item nav-item" role="presentation">
				<button class="booking-tab-slider__anchor <?php echo ($option->disabledDay === '') ? $isActive : ''; ?>" data-bs-toggle="tab" data-bs-target="#gr-<?php echo $curGroup; ?>" type="button" role="tab" aria-controls="gr-<?php echo $curGroup; ?>" <?php echo $option->disabledDay; ?>>  <!-- aria-selected="true" -->
					<div class="booking-tab-slider__dateexp d-flex flex-column">
						<div><?php echo Factory::getDate($curGroup, 'UTC')->format('D'); ?></div>
						<div class="primary-dateexp"><?php echo Factory::getDate($curGroup, 'UTC')->format('d. M'); ?></div>
						<div><?php echo Factory::getDate($curGroup, 'UTC')->format('Y'); ?></div>
					</div>
				</button>
			</li>
			<?php $isActive = ($option->disabledDay === '') ? '' : $isActive; ?>
		<?php endforeach; ?>
	</ul>
		<button id="booking-next" class="booking-tab-slider__next" type="button" role="button">
			<span class="icon-chevron-right" aria-hidden="true"></span>
		</button>
	</div>

<?php endif; ?>

<fieldset id="<?php echo $id; ?>" class="<?php echo trim($class . ' radio'); ?>" <?php echo $disabled ? 'disabled' : ''; ?> <?php echo $required ? 'required' : ''; ?> <?php echo $autofocus ? 'autofocus' : ''; ?> <?php echo $dataAttribute; ?>>

	<?php if (!empty($options)) : ?>
		<div class="booking-tab__options booking-options tab-content">
			<?php $curGroup = ''; ?>
			<?php $isActive = ' active'; ?>
			<?php foreach ($options as $i => $option) : ?>
				<?php if (trim($option->disabledDay) === 'disabled') :
					continue;
				endif; ?>
				<?php if ($curGroup !== $option->group) : ?>
					<?php echo ($curGroup !== '') ? '</div>' : ''; ?>
					<?php $required = ($required && $curGroup === ''); ?>
					<div class="booking-tab__parts tab-pane fade show<?php echo $isActive; ?>" id="gr-<?php echo $option->group; ?>" role="tabpanel" aria-labelledby="gr-<?php echo $option->group; ?>-tab">
						<?php $isActive = ''; ?>
						<?php $curGroup = $option->group ?>
				<?php endif; ?>
					<?php
					// Initialize some option attributes.
					$checked     = ((string) $option->value === $value) ? 'checked="checked"' : '';
					$optionClass = $option->class ?: '';
					$toggleClass = !empty($optionClass) ? 'class="form-check-input ' . $optionClass . '"' : 'class="form-check-input"';
					$disabled    = !empty($option->disable) || ($disabled && !$checked) ? 'disabled' : '';

					// Initialize some JavaScript option attributes.
					$onclick    = !empty($option->onclick) ? 'onclick="' . $option->onclick . '"' : '';
					$onchange   = !empty($option->onchange) ? 'onchange="' . $option->onchange . '"' : '';
					$oid        = $id . $i;
					$ovalue     = htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8');
					$attributes = array_filter([$checked, $toggleClass, $disabled, $onchange, $onclick]);
					?>
					<?php //if ($required) : ?>
						<?php $attributes[] = ($required) ? 'required' : 'disabled'; ?>
					<?php //endif; ?>
					<div class="radio form-check mb-0">
						<?php echo sprintf($format, $oid, $name, $ovalue, implode(' ', $attributes), $option->group); ?>
						<label for="<?php echo $oid; ?>" class="form-check-label <?php echo trim($optionClass); ?>">
						<?php echo Factory::getDate($option->text, 'UTC')->format('H:i'); ?>       
						</label>
					</div>
			<?php endforeach; ?>
					</div><!--  -->
	<?php endif; ?>
		</div>
</fieldset>
<?php if (!empty($options)) : ?>
<div class="booking-info">
	<span class="icon-info-circle" data-utcinfo="<?php $utcInfo; ?>"></span>
	<span class="booking-info__text"><?php echo Text::sprintf('MOD_SISMOSAPPOINTMENT_BOOKING_DURATION_INFO', $durationInfo);?></span>
	<span class="booking-info__text"><?php echo Text::sprintf('MOD_SISMOSAPPOINTMENT_BOOKING_TIMEZONE_INFO', $utcInfo);?></span>
</div>
<?php endif; ?>

<?php // Include the Bootstrap Tab Component
HTMLHelper::_('bootstrap.tab', '#' . preg_replace('/^[\.#]/', '', 'booking-tab'), ['isJoomla' => false]); ?>